﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.IO;
using Nintendo.ToolFoundation.Contracts;

namespace NintendoWare.SoundAdditionalInfoConverter.Binaries
{
    internal class BinaryHeader
    {
        // 8byte
        internal string Signature { get; set; }

        // 4byte
        internal BinaryVersion Version { get; set; }

        // 2byte
        internal ushort ByteOrderMark { get; set; }

        // 1byte
        internal byte Alignment { get; set; }

        // 1byte
        internal byte AddressSize { get; set; }

        // 4byte
        internal int OffsetToFileName { get; set; }

        // 2byte
        internal ushort Flags { get; set; }

        // 2byte
        internal short OffsetToBody { get; set; }

        // 4byte
        internal int OffsetToRelocationTable { get; set; }

        // 4byte
        internal int FileSize { get; set; }

        internal BinaryHeader()
        {
            this.Signature = string.Empty;
            this.Version = new BinaryVersion(1, 0, 0);
            this.ByteOrderMark = 0xFEFF;       // ひとまずリトルエンディアンで統一
            this.Alignment = 2;                // 2^2 で 4byte。
            this.AddressSize = 64;
            this.OffsetToFileName = 0;         // 非対応
            this.Flags = 0;                    // 非対応
            this.OffsetToBody = 0;
            this.OffsetToRelocationTable = 0;  // 非対応
            this.FileSize = 0;
        }

        internal int GetSize()
        {
            // TODO: もう少しメンテしやすい方法を調べる
            int size = 0;
            size += sizeof(byte) * this.Signature.Length; // char だと utf16 扱いになる
            size += this.Version.GetSize();
            size += sizeof(ushort);
            size += sizeof(byte);
            size += sizeof(byte);
            size += sizeof(int);
            size += sizeof(ushort);
            size += sizeof(short);
            size += sizeof(int);
            size += sizeof(int);

            Ensure.Operation.True(size == 32);

            return size;
        }

        internal void Output(BinaryWriter binaryWriter)
        {
            binaryWriter.Write(this.Signature.ToCharArray());

            binaryWriter.Write(this.Version.ToInt());

            binaryWriter.Write(this.ByteOrderMark);
            binaryWriter.Write(this.Alignment);
            binaryWriter.Write(this.AddressSize);
            binaryWriter.Write(this.OffsetToFileName);
            binaryWriter.Write(this.Flags);
            binaryWriter.Write(this.OffsetToBody);
            binaryWriter.Write(this.OffsetToRelocationTable);
            binaryWriter.Write(this.FileSize);
        }
    }
}
