﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdint>

#include "codec_AdpcmEncoderWrapper.h"
#include "../../../../../../../../Eris/Sources/Libraries/codec/codec_AdpcmEncoder.h"
#include "../../../../../../../../Eris/Sources/Libraries/codec/codec_AdpcmEncoderDesign.h"

extern "C" void nncodecCalculateCoefficients(int16_t* input, int sampleCount, void* cxt)
{
    auto pContext = reinterpret_cast<nn::codec::AdpcmInfo*>(cxt);
    return nn::codec::CalculateCoefficients(input, sampleCount, pContext);
}

extern "C" uint16_t nncodecEncodeAdpcm(int16_t *inbuffer, uint8_t *outbuffer, int16_t *coeftable, uint8_t step)
{
    return nn::codec::EncodeAdpcm(inbuffer, outbuffer, coeftable, step);
}
