﻿namespace Opal.Windows.Documents
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Controls;
    using Opal.ViewModels;

    /// <summary>
    /// ドキュメント作成抽象クラスです。
    /// </summary>
    public abstract class DocumentMaker
    {
        private readonly string key;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="key">ドキュメントのキーです。</param>
        protected DocumentMaker(string key)
        {
            Debug.Assert(!string.IsNullOrWhiteSpace(key));
            Debug.Assert(key.Length >= 3);

            this.key = key;
        }

        /// <summary>
        /// ツールのキーを取得します。
        /// </summary>
        public string Key
        {
            get
            {
                return this.key;
            }
        }

        /// <summary>
        /// ビューを生成します。
        /// </summary>
        /// <returns>ビューのインスタンスを返します。</returns>
        public abstract Control CreateView();

        /// <summary>
        /// ビューに対応するビューモデルを生成します。
        /// </summary>
        /// <returns>ビューモデルのインスタンスを返します。</returns>
        public abstract DocumentViewModel CreateViewModel();

        /// <summary>
        /// ドキュメントを生成します。
        /// </summary>
        /// <returns>ツールビューモデルのインスタンスを返します。</returns>
        internal DocumentViewModel CreateDocument()
        {
            var view = this.CreateView();
            var viewModel = this.CreateViewModel();
            viewModel.PaneView = view;
            return viewModel;
        }
    }
}
