﻿namespace Opal.Windows.Data
{
    /// <summary>
    /// EnumViewer 用の表示登録クラスです。
    /// </summary>
    public class EnumViewEntry
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public EnumViewEntry()
        {
            this.IsEnabled = true;
        }

        /// <summary>
        /// Enumの値を取得または設定します。
        /// </summary>
        public string EnumValue { get; set; }

        /// <summary>
        /// Enumの値に対応するラベル名を取得または設定します。
        /// </summary>
        public string LabelName { get; set; }

        /// <summary>
        /// 列挙値の有効性を取得または設定します。
        /// </summary>
        public bool IsEnabled { get; set; }

        /// <summary>
        /// EnumViewEntry を文字列に変換します。。
        /// </summary>
        /// <returns>変換した文字列を返します。</returns>
        public override string ToString()
        {
            return this.LabelName == null ? string.Empty : this.LabelName;
        }
    }
}
