﻿namespace Opal.Windows.Controls
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using Opal.ViewModels;

    /// <summary>
    /// ペインのスタイルセレクタークラスです。
    /// </summary>
    public sealed class PaneStyleSelector : StyleSelector
    {
        private Style toolStyle = null;
        private Style documentStyle = null;

        /// <summary>
        /// ツールのスタイルを取得設定します。
        /// </summary>
        public Style ToolStyle
        {
            get
            {
                return this.toolStyle;
            }

            set
            {
                this.toolStyle = value;
            }
        }

        /// <summary>
        /// ドキュメントのスタイルを取得設定します。
        /// </summary>
        public Style DocumentStyle
        {
            get
            {
                return this.documentStyle;
            }

            set
            {
                this.documentStyle = value;
            }
        }

        /// <summary>
        /// スタイルを選択します。
        /// </summary>
        /// <param name="item">コンテンツのアイテムです。</param>
        /// <param name="container">スタイル適用対象の要素です。</param>
        /// <returns>ツールかドキュメントのスタイルを返します。それ以外はnull を返します。</returns>
        public override Style SelectStyle(object item, DependencyObject container)
        {
            if (item is ToolViewModel)
            {
                return this.ToolStyle;
            }

            if (item is DocumentViewModel)
            {
                return this.DocumentStyle;
            }

            return base.SelectStyle(item, container);
        }
    }
}
