﻿namespace Opal.ViewModels
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// 値を記録可能なビューモデルです。
    /// </summary>
    /// <typeparam name="TValue">記録する値のテンプレートの型です。</typeparam>
    public class ValueRecordableViewModel<TValue> : ObservableValueViewModel
    {
        private TValue initValue;
        private TValue editValue;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="initValue">初期値です。</param>
        public ValueRecordableViewModel(TValue initValue)
        {
            this.initValue = initValue;
            this.editValue = initValue;
        }

        /// <summary>
        /// 初期値を取得設定します。
        /// </summary>
        protected TValue InitValue
        {
            get
            {
                return this.initValue;
            }

            set
            {
                this.SetProperty(ref this.initValue, value);
            }
        }

        /// <summary>
        /// 編集値を取得設定します。
        /// </summary>
        protected TValue EditValue
        {
            get
            {
                return this.editValue;
            }

            set
            {
                this.SetProperty(ref this.editValue, value, () => this.IsValueChanged = this.CompareValues());
            }
        }

        /// <summary>
        /// 初期値と編集値をを比較します。
        /// </summary>
        /// <returns>同一の場合は、true を返します。</returns>
        protected virtual bool CompareValues()
        {
            return EqualityComparer<TValue>.Default.Equals(this.initValue, this.editValue);
        }
    }
}
