﻿namespace Opal.Utilities
{
    using System.Collections.Generic;

    /// <summary>
    /// ファイルオプションを管理します。
    /// </summary>
    public class FileOption
    {
        private readonly string path;
        private List<ArgumentOption> options = new List<ArgumentOption>();

        ////---------------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="path">パスです。</param>
        public FileOption(string path)
        {
            this.path = path;
        }

        ////---------------------------------------------------------------------

        /// <summary>
        /// パスです。
        /// </summary>
        public string Path
        {
            get
            {
                return this.path;
            }
        }

        /// <summary>
        /// オプションです。
        /// </summary>
        public List<ArgumentOption> Options
        {
            get
            {
                return this.options;
            }
        }

        ////---------------------------------------------------------------------

        /// <summary>
        /// オプションを取得します。
        /// </summary>
        /// <param name="optionName">オプションの名前です。</param>
        /// <returns>オプションを返します。</returns>
        public ArgumentOption GetOption(string optionName)
        {
            return this.Options.Find(
                delegate(ArgumentOption mutch) { return mutch.Name == optionName; });
        }

        /// <summary>
        /// オプションの有無を取得します。
        /// </summary>
        /// <param name="optionName">オプションの名前です。</param>
        /// <returns>オプションがある場合には true を返します。</returns>
        public bool HasOption(string optionName)
        {
            return this.GetOption(optionName) != null;
        }
    }
}
