﻿namespace Opal.Utilities
{
    /// <summary>
    /// 引数オプションを管理します。
    /// </summary>
    public class ArgumentOption
    {
        private readonly string optionString;
        private readonly string name;

        ////---------------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="optionString">引数の文字列です。</param>
        /// <param name="name">引数の名前です。</param>
        public ArgumentOption(string optionString, string name)
        {
            this.optionString = optionString;
            this.name = name;
        }

        ////---------------------------------------------------------------------

        /// <summary>
        /// 引数の名前です。
        /// </summary>
        public string Name
        {
            get
            {
                return this.name;
            }
        }

        /// <summary>
        /// 引数の値です。
        /// </summary>
        public string Value { get; set; }

        /// <summary>
        /// 値をもっているかを取得します。
        /// </summary>
        public bool HasValue
        {
            get
            {
                return this.Value != null;
            }
        }

        ////---------------------------------------------------------------------

        /// <summary>
        /// 現在のオブジェクトを表す文字列を返します。
        /// </summary>
        /// <returns>現在のオブジェクトを表す文字列です。</returns>
        public override string ToString()
        {
            return this.optionString;
        }
    }
}
