﻿namespace Opal.Threading
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.IO;
    using System.Linq;
    using System.Text;
    using System.Threading;
    using System.Threading.Tasks;
    using System.Xml;
    using System.Xml.Serialization;

    /// <summary>
    /// スレッドジョブクラスです。
    /// </summary>
    public sealed class ThreadJob : Job
    {
        private Thread thread;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="name">ジョブの名前です。</param>
        public ThreadJob(string name)
            : base(name)
        {
        }

        /// <summary>
        /// スレッドを設定します。
        /// </summary>
        /// <param name="thread">設定するスレッドです。</param>
        public void SetThread(Thread thread)
        {
            this.thread = thread;
        }

        /// <summary>
        /// スレッドを取得します。
        /// </summary>
        /// <returns>設定しているスレッドを返します。</returns>
        public Thread GetThread()
        {
            return this.thread;
        }

        /// <summary>
        /// スレッドを停止します。
        /// </summary>
        public override void Stop()
        {
            if (this.thread != null)
            {
                this.thread.Abort();
            }
        }
    }
}
