﻿namespace Opal.Plugins
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// プラグインのインポートクラスです。
    /// </summary>
    internal class PluginImport : IPartImportsSatisfiedNotification
    {
        private bool isSatisfied = false;

        /// <summary>
        /// プラグイングループを取得します。
        /// </summary>
        [ImportMany(AllowRecomposition = true)]
        public IEnumerable<Lazy<IPlugin>> Plugins { get; set; }

        /// <summary>
        /// インポートが終了したか判定します。
        /// </summary>
        public bool IsSatisfied
        {
            get
            {
                return this.isSatisfied;
            }
        }

        /// <summary>
        /// インポート終了時に実行される処理です。
        /// </summary>
        public void OnImportsSatisfied()
        {
            this.isSatisfied = true;
        }
    }
}
