﻿namespace Opal.Operations
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Utilities;

    /// <summary>
    /// ISettable インターフェースを持つ参照型のインスタンスを変更せずに値を変えるオペレーションです。
    /// </summary>
    /// <typeparam name="TObject">編集対象となるプロパティのテンプレート型です。</typeparam>
    public sealed class SettableOperation<TObject> : Operation where TObject : class, ISettable
    {
        private readonly TObject target;
        private TObject data;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="target">編集対象の参照型です。</param>
        /// <param name="data">編集対象に設定する値です。</param>
        public SettableOperation(TObject target, TObject data)
        {
            Debug.Assert(target != null);
            Debug.Assert(data != null);

            this.target = target;
            this.data = (TObject)data.Clone();
        }

        /// <summary>
        /// オペレーションを実行します。
        /// </summary>
        /// <returns>実行時に返される Operation です。</returns>
        public override Operation Execute()
        {
            var temp = (TObject)this.target.Clone();
            Debug.Assert(temp != null);

            this.target.Set(this.data);
            this.data = temp;

            return this;
        }
    }
}
