﻿namespace Opal.Operations
{
    /// <summary>
    /// オペレーションの抽象クラスです。
    /// </summary>
    public abstract class Operation
    {
        private string description = string.Empty;

        /// <summary>
        /// ディスクリプションを取得設定します。
        /// </summary>
        public string Description
        {
            get
            {
                return this.description;
            }

            set
            {
                this.description = value != null ? value : string.Empty;
            }
        }

        /// <summary>
        /// マージ可能か判定します。
        /// </summary>
        public virtual bool IsMergeable
        {
            get
            {
                return false;
            }
        }

        /// <summary>
        /// オペレーションを実行します。
        /// </summary>
        /// <returns>実行時に返される IOperation です。</returns>
        public abstract Operation Execute();

        /// <summary>
        /// アンドゥ可能か判定します。
        /// </summary>
        /// <returns>true ならばアンドゥ対象です。</returns>
        public virtual bool CanUndoable()
        {
            return true;
        }

        /// <summary>
        /// マージ対象であるか判定するためのハッシュコードを取得します。
        /// </summary>
        /// <returns>マージ対象判定用のハッシュコードを返します。</returns>
        public virtual int GetMergeableHashCode()
        {
            return 0;
        }
    }
}
