﻿namespace Opal.Operations
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// リスト挿入オペレーションです。
    /// </summary>
    /// <typeparam name="TObject">リストアイテムのテンプレート型です。</typeparam>
    public sealed class ListItemInsertOperation<TObject> : ListItemOperation<TObject>
    {
        private int insertIndex = -1;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="target">編集対象です。</param>
        /// <param name="item">対象のアイテムです。</param>
        /// <param name="insertIndex">挿入対象のアイテムのインデックスです。</param>
        public ListItemInsertOperation(IList<TObject> target, TObject item, int insertIndex)
            : base(target, item)
        {
            Debug.Assert(target.Count > insertIndex && insertIndex >= 0);

            this.insertIndex = insertIndex;
        }

        /// <summary>
        /// Undo を実行します。
        /// </summary>
        /// <param name="target">編集対象です。</param>
        /// <param name="item">対象のアイテムです。</param>
        protected override void Undo(IList<TObject> target, TObject item)
        {
            Debug.Assert(target.Contains(item));
            Debug.Assert(target.Count > this.insertIndex && this.insertIndex >= 0);

            if (this.IsValueType)
            {
                Debug.Assert(object.Equals(target[this.insertIndex], item));
            }
            else
            {
                Debug.Assert(object.ReferenceEquals(target[this.insertIndex], item));
            }

            target.RemoveAt(this.insertIndex);
        }

        /// <summary>
        /// Redo を実行します。
        /// </summary>
        /// <param name="target">編集対象です。</param>
        /// <param name="item">対象のアイテムです。</param>
        protected override void Redo(IList<TObject> target, TObject item)
        {
            target.Insert(this.insertIndex, item);
        }
    }
}
