﻿namespace Opal.Operations
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Utilities;

    /// <summary>
    /// リスト追加オペレーションです。
    /// </summary>
    /// <typeparam name="TObject">リストアイテムのテンプレート型です。</typeparam>
    public sealed class ListItemAddOperation<TObject> : ListItemOperation<TObject>
    {
        private int itemIndex = 0;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="target">編集対象です。</param>
        /// <param name="item">対象のアイテムです。</param>
        public ListItemAddOperation(IList<TObject> target, TObject item)
            : base(target, item)
        {
        }

        /// <summary>
        /// Undo を実行します。
        /// </summary>
        /// <param name="target">編集対象です。</param>
        /// <param name="item">対象のアイテムです。</param>
        protected override void Undo(IList<TObject> target, TObject item)
        {
            if (this.IsValueType)
            {
                if (!object.Equals(target[this.itemIndex], item))
                {
                    ExceptionUtility.Throw();
                }
            }
            else
            {
                if (!object.ReferenceEquals(target[this.itemIndex], item))
                {
                    ExceptionUtility.Throw();
                }
            }

            target.RemoveAt(this.itemIndex);
        }

        /// <summary>
        /// Redo を実行します。
        /// </summary>
        /// <param name="target">編集対象です。</param>
        /// <param name="item">対象のアイテムです。</param>
        protected override void Redo(IList<TObject> target, TObject item)
        {
            this.itemIndex = target.Count;
            target.Add(item);
        }
    }
}
