﻿namespace Opal.Operations
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Utilities;

    /// <summary>
    /// リストのクリアオペレーションです。
    /// </summary>
    /// <typeparam name="TObject">リストアイテムのテンプレート型です。</typeparam>
    public sealed class ListClearOperation<TObject> : Operation
    {
        private readonly IList<TObject> target;
        private readonly List<TObject> sourceList = new List<TObject>();
        private bool undoFlag = false;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="target">編集対象です。</param>
        /// <param name="keySelector">キーセレクタです。</param>
        /// <param name="isDescendingOrder">降順の場合はtrueを指定します。</param>
        public ListClearOperation(IList<TObject> target)
        {
            this.target = target;
        }

        /// <summary>
        /// マージ可能か判定します。
        /// </summary>
        public override bool IsMergeable
        {
            get
            {
                return false;
            }
        }

        /// <summary>
        /// オペレーションを実行します。
        /// </summary>
        /// <returns>実行時に返される Operation です。</returns>
        public override Operation Execute()
        {
            if (this.undoFlag)
            {
                this.Undo();
            }
            else
            {
                this.sourceList.Clear();
                this.sourceList.AddRange(this.target);
                this.Redo();
            }

            this.undoFlag = !this.undoFlag;

            return this;
        }

        /// <summary>
        /// Undo を実行します。
        /// </summary>
        private void Undo()
        {
            foreach (var item in this.sourceList)
            {
                this.target.Add(item);
            }
        }

        /// <summary>
        /// Redo を実行します。
        /// </summary>
        private void Redo()
        {
            this.target.Clear();
        }
    }
}
