﻿namespace Opal.Operations
{
    using System;
    using System.Collections.ObjectModel;
    using System.Diagnostics;

    /// <summary>
    /// キーが値に埋め込まれているコレクションの追加オペレーションです。
    /// </summary>
    /// <typeparam name="TKey">コレクションアイテムキーのテンプレート型です。</typeparam>
    /// <typeparam name="TItem">コレクションアイテムのテンプレート型です。</typeparam>
    public sealed class KeyedCollectionItemAddOperation<TKey, TItem> : KeyedCollectionItemOperation<TKey, TItem>
    {
        private readonly TItem item;
        private int index = -1;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="target">編集対象です。</param>
        /// <param name="key">対象のアイテムのキーです。</param>
        /// <param name="item">対象のアイテムです。</param>
        public KeyedCollectionItemAddOperation(KeyedCollection<TKey, TItem> target, TItem item)
            : base(target)
        {
            Debug.Assert(item != null);
            this.item = item;
        }

        /// <summary>
        /// Undo を実行します。
        /// </summary>
        /// <param name="target">編集対象です。</param>
        /// <param name="key">対象のアイテムのキーです。</param>
        protected override void Undo(KeyedCollection<TKey, TItem> target, TKey key)
        {
            if (this.index == -1)
            {
                return;
            }

            Debug.Assert(this.index < target.Count);
            target.RemoveAt(this.index);
        }

        /// <summary>
        /// Redo を実行します。
        /// </summary>
        /// <param name="target">編集対象です。</param>
        /// <param name="key">対象のアイテムのキーです。</param>
        protected override void Redo(KeyedCollection<TKey, TItem> target, TKey key)
        {
            this.index = target.Count;

            try
            {
                target.Add(this.item);
            }
            catch (Exception)
            {
                // 対象と同じキーを持つアイテムが既に存在する場合は何もしない
                this.index = -1;
                return;
            }
        }
    }
}
