﻿namespace Opal.Operations.Applications
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.App;
    using Opal.Resources;

    /// <summary>
    /// リドゥオペレーションクラスです。
    /// </summary>
    public sealed class RedoOperation : Operation
    {
        private bool isRedo = true;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public RedoOperation()
        {
        }

        /// <summary>
        /// マージ可能か判定します。
        /// </summary>
        public override bool IsMergeable
        {
            get
            {
                return true;
            }
        }

        /// <summary>
        /// オペレーションを実行します。
        /// </summary>
        /// <returns>実行時に返される IOperation です。</returns>
        public override Operation Execute()
        {
            var operationManager = AppManager.GetOperationManager();
            Debug.Assert(operationManager != null);
            if (this.isRedo)
            {
                Debug.Assert(operationManager.CanRedo());
                operationManager.Redo();
                this.isRedo = false;
            }
            else
            {
                Debug.Assert(operationManager.CanUndo());
                operationManager.Undo();
                this.isRedo = true;
            }

            return this;
        }
    }
}
