﻿namespace Opal.Modules.Output
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using System.Windows.Data;
    using System.Windows.Documents;
    using System.Windows.Input;
    using System.Windows.Media;
    using System.Windows.Media.Imaging;
    using System.Windows.Navigation;
    using System.Windows.Shapes;

    /// <summary>
    /// OutputView.xaml の相互作用ロジック
    /// </summary>
    public partial class OutputView : UserControl, IOutputView
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OutputView()
        {
            this.InitializeComponent();
        }
#if true
        /// <summary>
        /// 最後のページにスクロールします。
        /// </summary>
        public void ScrollToEnd()
        {
            if (listView.Items.Count > 0)
            {
                listView.ScrollIntoView(listView.Items[listView.Items.Count - 1]);
            }
        }

        /// <summary>
        /// クリアします。
        /// </summary>
        public void Clear()
        {
        }

        /// <summary>
        /// テキストを追加します。
        /// </summary>
        /// <param name="text">追加対象のテキストです。</param>
        public void AppendText(string text)
        {
            this.ScrollToEnd();
        }

        /// <summary>
        /// テキストを設定します。
        /// </summary>
        /// <param name="text">設定対象のテキストです。</param>
        public void SetText(string text)
        {
            this.ScrollToEnd();
        }
#endif
    }
}
