﻿namespace Opal.Modules.Output
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// ログ出力ビューインターフェースです。
    /// </summary>
    public interface IOutputView
    {
        /// <summary>
        /// クリアします。
        /// </summary>
        void Clear();

        /// <summary>
        /// 最後のページにスクロールします。
        /// </summary>
        void ScrollToEnd();

        /// <summary>
        /// テキストを追加します。
        /// </summary>
        /// <param name="text">追加対象のテキストです。</param>
        void AppendText(string text);

        /// <summary>
        /// テキストを設定します。
        /// </summary>
        /// <param name="text">設定対象のテキストです。</param>
        void SetText(string text);
    }
}
