﻿namespace Opal.Menus
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.ComponentModel;

    /// <summary>
    /// メインメニューカテゴリです。
    /// </summary>
    public enum MenuCategory
    {
        /// <summary>
        /// ファイル > 新規作成 のカテゴリです。
        /// </summary>
        FileNew,

        /// <summary>
        /// ファイル > 開く のカテゴリです。
        /// </summary>
        FileOpen,

        /// <summary>
        /// 保存時のカテゴリです。
        /// </summary>
        FileSave,

        /// <summary>
        /// ファイル 内に含まれるカテゴリです。
        /// </summary>
        FileEtc,

        /// <summary>
        /// ツール のカテゴリです。
        /// </summary>
        Tool,
    }

    /// <summary>
    /// メニューの基底クラスです。
    /// </summary>
    public abstract class Menu : DisposableObservableObject
    {
        private string label = string.Empty;
        private bool isCheckable = false;
        private bool isChecked = false;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="label">ラベル名です。</param>
        protected Menu(string label)
        {
            Debug.Assert(label != null);
            this.label = label;
        }

        /// <summary>
        /// メニュー内のどの種類かを取得します。
        /// </summary>
        public virtual MenuCategory Category
        {
            get
            {
                return MenuCategory.FileEtc;
            }
        }

        /// <summary>
        /// メニュー表示されるラベル名を取得します。
        /// </summary>
        public string Label
        {
            get
            {
                return this.label;
            }

            protected set
            {
                this.SetProperty(ref this.label, value);
            }
        }

        /// <summary>
        /// チェック マークを付けることができるかどうかを示す値を取得します。
        /// </summary>
        public bool IsCheckable
        {
            get
            {
                return this.isCheckable;
            }

            protected set
            {
                this.SetProperty(ref this.isCheckable, value);
            }
        }

        /// <summary>
        /// チェック マークが付いているかどうかを示す値を取得または設定します。
        /// </summary>
        public bool IsChecked
        {
            get
            {
                return this.isChecked;
            }

            protected set
            {
                this.SetProperty(ref this.isChecked, value);
            }
        }
    }
}
