﻿namespace Opal.Events
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// イベントハンドラの登録を取り消すコールバックです。
    /// </summary>
    /// <typeparam name="TEventArgs">イベント引数のテンプレートの型です。</typeparam>
    /// <param name="handler">イベントハンドラです。</param>
    public delegate void UnregisterCallback<TEventArgs>(EventHandler<TEventArgs> handler)
            where TEventArgs : EventArgs;

    /// <summary>
    /// 弱参照イベントハンドラインターフェースです。
    /// </summary>
    /// <typeparam name="TEventArgs">イベント引数のテンプレートの型です。</typeparam>
    public interface IWeakEventHandler<TEventArgs> where TEventArgs : EventArgs
    {
        /// <summary>
        /// イベントハンドラを取得します。
        /// </summary>
        EventHandler<TEventArgs> Handler { get; }
    }
}
