﻿namespace Opal.Events
{
    using System;
    using System.Collections.Concurrent;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// EventArgs のファクトリクラスです。
    /// </summary>
    internal static class EventArgsFactory
    {
        private static readonly ConcurrentDictionary<string, PropertyChangedEventArgs> PropertyChangedEventArgsDictionary = new ConcurrentDictionary<string, PropertyChangedEventArgs>();

        /// <summary>
        /// プロパティ名に対応するPropertyEventChangedArgs を取得します。
        /// </summary>
        /// <param name="propertyName">プロパティ名です。</param>
        /// <returns>プロパティ名に対応するPropertyChangedEventArgsのインスタンスを返します。 </returns>
        public static PropertyChangedEventArgs GetPropertyChangedEventArgs(string propertyName)
        {
            return PropertyChangedEventArgsDictionary.GetOrAdd(propertyName, name => new PropertyChangedEventArgs(name));
        }
    }
}
