﻿namespace Opal.ComponentModel
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// 同期オブジェクトを持つオブジェクトです。
    /// SyncRoot を毎回定義したくないためのクラスです。
    /// </summary>
    public abstract class SynchronizableObject
    {
        private readonly object syncRoot = new object();

        /// <summary>
        /// 同期オブジェクトを取得します。
        /// </summary>
        protected object SyncRoot
        {
            get
            {
                return this.syncRoot;
            }
        }
    }
}
