﻿namespace Opal.ComponentModel
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// 破棄処理と通知機能付きのオブジェクトです。
    /// </summary>
    public abstract class DisposableObservableObject : ObservableObject, IDisposable
    {
        private bool disposed = false;

        /// <summary>
        /// デストラクタです。
        /// </summary>
        ~DisposableObservableObject()
        {
            // Dispose前に実行された場合はアサート
            Debug.Assert(!this.disposed);
        }

        /// <summary>
        /// オブジェクトを破棄します。
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
            GC.SuppressFinalize(this);
        }

        /// <summary>
        /// オブジェクト破棄の内部処理です。継承した先で固有の処理を実装します。
        /// </summary>
        protected virtual void DisposeInternal()
        {
        }

        /// <summary>
        /// オブジェクトを破棄します。
        /// </summary>
        /// <param name="disposing">true時に破棄処理を行います。</param>
        private void Dispose(bool disposing)
        {
            if (this.disposed)
            {
                return;
            }

            if (disposing)
            {
                this.DisposeInternal();
            }

            this.disposed = true;
        }
    }
}
