﻿using Nintendo.G3dTool.Entities;
using Nintendo.G3dTool.Entities.Internal;
using Nintendo.ToolFoundation.Contracts;
using nw.g3d.nw4f_3dif;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.G3dTool.Extensions
{
    public static class VertexExtensions
    {
        /// <summary>
        /// 名前やインデックスで間接的に参照しているデータを含めてディープコピーします。
        /// </summary>
        /// <param name="vertex"></param>
        /// <returns></returns>
        public static Vertex DeepCopyWithReferences(this Vertex vertex, Model parentModel)
        {
            var copiedVertex = new Vertex(vertex);
            parentModel.Vertexes.Add(copiedVertex);
            foreach (var attr in vertex.VtxAttribs)
            {
                var copiedAttr = copiedVertex.VtxAttribs.First(x => x.Name == attr.Name);
                copiedAttr.Stream = StreamUtility.CreateStream(attr.Stream);
                parentModel.Streams.Add(copiedAttr.Stream);
            }

            return copiedVertex;
        }
    }
}
