﻿using Nintendo.G3dTool.Entities;
using Nintendo.ToolFoundation.Contracts;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.G3dTool.Extensions
{
    public static class SkeletonExtensions
    {
        public static void RemoveBone(this Skeleton skeleton, Bone target)
        {
            Ensure.Argument.True(skeleton.EnumerateBones().Contains(target), $"Skeleton does not have input bone \"{target.Name}\"");
            if (target.ParentBone == null)
            {
                skeleton.RootBone = null;
            }
            else
            {
                target.ParentBone.ChildBones.Remove(target);
            }
        }
    }
}
