﻿using Nintendo.G3dTool.Entities;
using Nintendo.ToolFoundation.Contracts;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.G3dTool.Extensions
{
    public static class SamplerAssignExtensions
    {
        public static void SetToDefault(this SamplerAssign target, SamplerVar definition, Material material)
        {
            target.Id = definition.Id;

            var sampler = material.Samplers.FirstOrDefault(x => x.Hint == definition.Hint);
            if (sampler != null)
            {
                target.SamplerName = sampler.Name;
            }
            else
            {
                target.SamplerName = string.Empty;
            }
        }
    }
}
