﻿using Nintendo.G3dTool.Entities;
using Nintendo.ToolFoundation.Contracts;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Nintendo.G3dTool.Extensions
{
    public static class FileInfoExtensions
    {
        public static void SetCreationInfo(this FileInfo target, string sourcePath)
        {
            target.Create.SrcPath = sourcePath;
            target.Create.ToolName = Application.ProductName;
            target.Create.ToolVersion = Application.ProductVersion;
        }

        public static void SetModificationInfo(this FileInfo target)
        {
            if (target.Create.IsEmpty)
            {
                // 作成情報がない場合はファイル情報を削除済みなので更新できない
                return;
            }

            target.Modify.ToolName = Application.ProductName;
            target.Modify.ToolVersion = Application.ProductVersion;
        }
    }
}
