﻿using Opal.Security.Cryptography;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.G3dTool.Entities
{
    public class RgbColor : IEquatable<RgbColor>
    {
        public RgbColor(double r, double g, double b)
        {
            this.R = r;
            this.G = g;
            this.B = b;
        }

        public double R { get; set; }

        public double G { get; set; }

        public double B { get; set; }

        /// <summary>
        /// 比較演算子
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>一致していれば true、そうでなければ false を返します。</returns>
        public override bool Equals(object obj)
        {
            if (object.ReferenceEquals(obj, null))
            {
                return false;
            }
            if (object.ReferenceEquals(this, obj))
            {
                return true;
            }
            if (this.GetType() != obj.GetType())
            {
                return false;
            }
            return this.Equals(obj as RgbColor);
        }

        public bool Equals(RgbColor obj)
        {
            var result = false;
            if (obj != null)
            {
                if (obj.R == this.R && obj.G == this.G && obj.B == this.B)
                {
                    result = true;
                }
            }
            return result;
        }

        /// <summary>
        /// GetHashCodeのオーバーライド。
        /// </summary>
        public override int GetHashCode()
        {
            CRC32 crc = new CRC32();
            return (int)crc.ComputeHashUInt32(this);
        }

        public override string ToString()
        {
            return $"{this.R.ToString()} {this.G.ToString()} {this.B.ToString()}";
        }
    }
}
