﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using nw.g3d.nw4f_3dif;
using Opal.Security.Cryptography;
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.G3dTool.Entities.Internal;
using System.Text.RegularExpressions;

namespace Nintendo.G3dTool.Entities
{
    public class RenderInfoStringChoice : ObservableEntity<string>, IEquatable<RenderInfoStringChoice>, IDeepCopyFrom<RenderInfoStringChoice>
    {
        private readonly ObservableList<ChoiceValueString> values = new ObservableList<ChoiceValueString>();

        public RenderInfoStringChoice()
        {
        }

        public RenderInfoStringChoice(string source)
            : this()
        {
            this.SetFromShaderAnnotationFormat(source);
        }

        public ObservableList<ChoiceValueString> Values
        {
            get
            {
                return this.values;
            }
        }

        private void SetFromShaderAnnotationFormat(string source)
        {
            string[] splitedWithComma = source.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
            this.Values.Clear();
            foreach (var elem in splitedWithComma)
            {
                string[] splitedWithColon = elem.Split(new char[] { ':' }, StringSplitOptions.RemoveEmptyEntries);
                this.Values.Add(new ChoiceValueString(splitedWithColon[0], splitedWithColon.Length == 2 ? splitedWithColon[1] : string.Empty));
            }
        }

        public bool Equals(RenderInfoStringChoice obj)
        {
            if (obj == null)
            {
                return false;
            }

            if (this.Values.Count != obj.Values.Count)
            {
                return false;
            }

            for (int elemIndex = 0; elemIndex < this.Values.Count; ++elemIndex)
            {
                if (this.Values[elemIndex] != obj.Values[elemIndex])
                {
                    return false;
                }
            }

            return true;
        }

        public override string CreateSerializableData()
        {
            if (this.Values.Count == 0)
            {
                return string.Empty;
            }

            return string.Join(",", this.values);
        }

        protected override uint CreateCRCInternal()
        {
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            foreach (var elem in this.Values)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(elem)));
            }
            return crc.ComputeHashUInt32(buffers.ToArray());
        }

        public void DeepCopyFrom(RenderInfoStringChoice source)
        {
            CopyValues(source.values, this.values);
        }
    }
}
