﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using nw.g3d.nw4f_3dif;
using Opal.Security.Cryptography;
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.G3dTool.Entities.Internal;

namespace Nintendo.G3dTool.Entities
{
    public abstract class RenderInfoSlot : ObservableEntity<render_info_slotType>, IUiElementHolder, IDeepCopyable<RenderInfoSlot>, IDeepCopyFrom<RenderInfoSlot>, IDisposable
    {
        private UiLabel @uiLabel = null;
        private UiComment @uiComment = null;
        private UiGroup @uiGroup = null;
        private UiOrder @uiOrder = null;
        private UiItem @uiItem = null;
        private UiVisible @uiVisible = null;
        private string @name = string.Empty;
        private int @count;
        private bool @optional;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public RenderInfoSlot()
        {
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public RenderInfoSlot(RenderInfoSlot source)
            : this()
        {
            this.DeepCopyFrom(source);
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public RenderInfoSlot(render_info_slotType source)
        {
            if (source.@ui_label != null)
            {
                this.UiLabel = new UiLabel(source.@ui_label);
            }
            else
            {
                this.UiLabel = null;
            }
            if (source.@ui_comment != null)
            {
                this.UiComment = new UiComment(source.@ui_comment);
            }
            else
            {
                this.UiComment = null;
            }
            if (source.@ui_group != null)
            {
                this.UiGroup = new UiGroup(source.@ui_group);
            }
            else
            {
                this.UiGroup = null;
            }
            if (source.@ui_order != null)
            {
                this.UiOrder = new UiOrder(source.@ui_order);
            }
            else
            {
                this.UiOrder = null;
            }
            if (source.@ui_item != null)
            {
                this.UiItem = new UiItem(source.@ui_item);
            }
            else
            {
                this.UiItem = null;
            }
            if (source.@ui_visible != null)
            {
                this.UiVisible = new UiVisible(source.@ui_visible);
            }
            else
            {
                this.UiVisible = null;
            }
            this.@name = source.@name;
            this.@count = source.@count;
            this.@optional = source.@optional;
        }

        public void Dispose()
        {
            if (this.@uiLabel != null)
            {
                this.@uiLabel.PropertyChanged -= this.OnPropertyChanged;
            }
            if (this.@uiComment != null)
            {
                this.@uiComment.PropertyChanged -= this.OnPropertyChanged;
            }
            if (this.@uiGroup != null)
            {
                this.@uiGroup.PropertyChanged -= this.OnPropertyChanged;
            }
            if (this.@uiOrder != null)
            {
                this.@uiOrder.PropertyChanged -= this.OnPropertyChanged;
            }
            if (this.@uiItem != null)
            {
                this.@uiItem.PropertyChanged -= this.OnPropertyChanged;
            }
            if (this.@uiVisible != null)
            {
                this.@uiVisible.PropertyChanged -= this.OnPropertyChanged;
            }
        }

        public UiLabel UiLabel
        {
            get
            {
                return this.@uiLabel;
            }

            set
            {
                if (this.@uiLabel == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? typeof(UiLabel).IsAssignableFrom(value.GetType()) : true);
                if (this.@uiLabel != null)
                {
                    (this.@uiLabel as IChildEntity).Parent = null;
                }

                if (value != null)
                {
                    (value as IChildEntity).Parent = this;
                }

                if (this.@uiLabel != null)
                {
                    this.@uiLabel.PropertyChanged -= this.OnPropertyChanged;
                }

                if (value != null)
                {
                    value.PropertyChanged += this.OnPropertyChanged;
                }

                this.SetProperty(ref this.@uiLabel, value, () => this.CalcCRC());
            }
        }

        public UiComment UiComment
        {
            get
            {
                return this.@uiComment;
            }

            set
            {
                if (this.@uiComment == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? typeof(UiComment).IsAssignableFrom(value.GetType()) : true);
                if (this.@uiComment != null)
                {
                    (this.@uiComment as IChildEntity).Parent = null;
                }

                if (value != null)
                {
                    (value as IChildEntity).Parent = this;
                }

                if (this.@uiComment != null)
                {
                    this.@uiComment.PropertyChanged -= this.OnPropertyChanged;
                }

                if (value != null)
                {
                    value.PropertyChanged += this.OnPropertyChanged;
                }

                this.SetProperty(ref this.@uiComment, value, () => this.CalcCRC());
            }
        }

        public UiGroup UiGroup
        {
            get
            {
                return this.@uiGroup;
            }

            set
            {
                if (this.@uiGroup == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? typeof(UiGroup).IsAssignableFrom(value.GetType()) : true);
                if (this.@uiGroup != null)
                {
                    (this.@uiGroup as IChildEntity).Parent = null;
                }

                if (value != null)
                {
                    (value as IChildEntity).Parent = this;
                }

                if (this.@uiGroup != null)
                {
                    this.@uiGroup.PropertyChanged -= this.OnPropertyChanged;
                }

                if (value != null)
                {
                    value.PropertyChanged += this.OnPropertyChanged;
                }

                this.SetProperty(ref this.@uiGroup, value, () => this.CalcCRC());
            }
        }

        public UiOrder UiOrder
        {
            get
            {
                return this.@uiOrder;
            }

            set
            {
                if (this.@uiOrder == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? typeof(UiOrder).IsAssignableFrom(value.GetType()) : true);
                if (this.@uiOrder != null)
                {
                    (this.@uiOrder as IChildEntity).Parent = null;
                }

                if (value != null)
                {
                    (value as IChildEntity).Parent = this;
                }

                if (this.@uiOrder != null)
                {
                    this.@uiOrder.PropertyChanged -= this.OnPropertyChanged;
                }

                if (value != null)
                {
                    value.PropertyChanged += this.OnPropertyChanged;
                }

                this.SetProperty(ref this.@uiOrder, value, () => this.CalcCRC());
            }
        }

        public UiItem UiItem
        {
            get
            {
                return this.@uiItem;
            }

            set
            {
                if (this.@uiItem == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? typeof(UiItem).IsAssignableFrom(value.GetType()) : true);
                if (this.@uiItem != null)
                {
                    (this.@uiItem as IChildEntity).Parent = null;
                }

                if (value != null)
                {
                    (value as IChildEntity).Parent = this;
                }

                if (this.@uiItem != null)
                {
                    this.@uiItem.PropertyChanged -= this.OnPropertyChanged;
                }

                if (value != null)
                {
                    value.PropertyChanged += this.OnPropertyChanged;
                }

                this.SetProperty(ref this.@uiItem, value, () => this.CalcCRC());
            }
        }

        public UiVisible UiVisible
        {
            get
            {
                return this.@uiVisible;
            }

            set
            {
                if (this.@uiVisible == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? typeof(UiVisible).IsAssignableFrom(value.GetType()) : true);
                if (this.@uiVisible != null)
                {
                    (this.@uiVisible as IChildEntity).Parent = null;
                }

                if (value != null)
                {
                    (value as IChildEntity).Parent = this;
                }

                if (this.@uiVisible != null)
                {
                    this.@uiVisible.PropertyChanged -= this.OnPropertyChanged;
                }

                if (value != null)
                {
                    value.PropertyChanged += this.OnPropertyChanged;
                }

                this.SetProperty(ref this.@uiVisible, value, () => this.CalcCRC());
            }
        }

        public string Name
        {
            get
            {
                return this.@name;
            }

            set
            {
                if (this.@name == value)
                {
                    return;
                }

                Ensure.Argument.NotNull(value);
                this.SetProperty(ref this.@name, value, () => this.CalcCRC());
            }
        }

        public int Count
        {
            get
            {
                return this.@count;
            }

            set
            {
                if (this.@count == value)
                {
                    return;
                }

                this.SetProperty(ref this.@count, value, () => this.CalcCRC());
            }
        }

        public bool Optional
        {
            get
            {
                return this.@optional;
            }

            set
            {
                if (this.@optional == value)
                {
                    return;
                }

                this.SetProperty(ref this.@optional, value, () => this.CalcCRC());
            }
        }

        public abstract render_info_slot_typeType Type{ get; }

        public RenderInfo CreateInstance()
        {
            return DataModelConverter.Convert(this);
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override render_info_slotType CreateSerializableData()
        {
            var writeData = new render_info_slotType();
            if (this.@uiLabel != null)
            {
                writeData.@ui_label = this.UiLabel.CreateSerializableData() as ui_labelType;
            }
            if (this.@uiComment != null)
            {
                writeData.@ui_comment = this.UiComment.CreateSerializableData() as ui_commentType;
            }
            if (this.@uiGroup != null)
            {
                writeData.@ui_group = this.UiGroup.CreateSerializableData() as ui_groupType;
            }
            if (this.@uiOrder != null)
            {
                writeData.@ui_order = this.UiOrder.CreateSerializableData() as ui_orderType;
            }
            if (this.@uiItem != null)
            {
                writeData.@ui_item = this.UiItem.CreateSerializableData() as ui_itemType;
            }
            if (this.@uiVisible != null)
            {
                writeData.@ui_visible = this.UiVisible.CreateSerializableData() as ui_visibleType;
            }
            writeData.@name = this.Name;
            writeData.@count = this.Count;
            writeData.@optional = this.Optional;
            return writeData;
        }

        /// <summary>
        /// 現在のインスタンスをディープコピーで複製した新規インスタンスを返します。
        /// </summary>
        RenderInfoSlot IDeepCopyable<RenderInfoSlot>.DeepCopy()
        {
            return this.DeepCopy();
        }

        /// <summary>
        /// 現在のインスタンスをディープコピーで複製した新規インスタンスを返します。
        /// </summary>
        private protected abstract RenderInfoSlot DeepCopy();

        /// <summary>
        /// 入力ファイルからディープコピーします。
        /// </summary>
        /// <param name="source">コピー元となる入力ファイルです。</param>
        public void DeepCopyFrom(RenderInfoSlot source)
        {
            if (source.@uiLabel == null)
            {
                this.UiLabel = null;
            }
            else
            {
                this.UiLabel.DeepCopyFrom(source.@uiLabel);
            }
            if (source.@uiComment == null)
            {
                this.UiComment = null;
            }
            else
            {
                this.UiComment.DeepCopyFrom(source.@uiComment);
            }
            if (source.@uiGroup == null)
            {
                this.UiGroup = null;
            }
            else
            {
                this.UiGroup.DeepCopyFrom(source.@uiGroup);
            }
            if (source.@uiOrder == null)
            {
                this.UiOrder = null;
            }
            else
            {
                this.UiOrder.DeepCopyFrom(source.@uiOrder);
            }
            if (source.@uiItem == null)
            {
                this.UiItem = null;
            }
            else
            {
                this.UiItem.DeepCopyFrom(source.@uiItem);
            }
            if (source.@uiVisible == null)
            {
                this.UiVisible = null;
            }
            else
            {
                this.UiVisible.DeepCopyFrom(source.@uiVisible);
            }
            this.@name = source.@name;
            this.@count = source.@count;
            this.@optional = source.@optional;
        }

        /// <summary>
        /// エンティティの CRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRC の値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            if (this.UiLabel != null)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UiLabel.HashValue)));
            }
            if (this.UiComment != null)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UiComment.HashValue)));
            }
            if (this.UiGroup != null)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UiGroup.HashValue)));
            }
            if (this.UiOrder != null)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UiOrder.HashValue)));
            }
            if (this.UiItem != null)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UiItem.HashValue)));
            }
            if (this.UiVisible != null)
            {
                buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UiVisible.HashValue)));
            }
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Name)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Count)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Optional)));
            return crc.ComputeHashUInt32(buffers.ToArray());
        }

        /// <summary>
        /// 自動計算フラグを設定します。(内部処理用）
        /// </summary>
        protected override void SetAutoCalcFlagInternal()
        {
            if (this.@uiLabel != null)
            {
                this.@uiLabel.AutoCalc = this.AutoCalc;
            }
            if (this.@uiComment != null)
            {
                this.@uiComment.AutoCalc = this.AutoCalc;
            }
            if (this.@uiGroup != null)
            {
                this.@uiGroup.AutoCalc = this.AutoCalc;
            }
            if (this.@uiOrder != null)
            {
                this.@uiOrder.AutoCalc = this.AutoCalc;
            }
            if (this.@uiItem != null)
            {
                this.@uiItem.AutoCalc = this.AutoCalc;
            }
            if (this.@uiVisible != null)
            {
                this.@uiVisible.AutoCalc = this.AutoCalc;
            }
        }

        /// <summary>
        /// エンティティの状態をリセットします。(内部処理用）
        /// </summary>
        protected override void ResetInternal()
        {
            if (this.@uiLabel != null)
            {
                this.@uiLabel.Reset();
            }
            if (this.@uiComment != null)
            {
                this.@uiComment.Reset();
            }
            if (this.@uiGroup != null)
            {
                this.@uiGroup.Reset();
            }
            if (this.@uiOrder != null)
            {
                this.@uiOrder.Reset();
            }
            if (this.@uiItem != null)
            {
                this.@uiItem.Reset();
            }
            if (this.@uiVisible != null)
            {
                this.@uiVisible.Reset();
            }
        }

        /// <summary>
        /// エンティティの状態を更新します。(内部処理用）
        /// </summary>
        protected override void RefreshInternal()
        {
            if (this.@uiLabel != null)
            {
                this.@uiLabel.Refresh();
            }
            if (this.@uiComment != null)
            {
                this.@uiComment.Refresh();
            }
            if (this.@uiGroup != null)
            {
                this.@uiGroup.Refresh();
            }
            if (this.@uiOrder != null)
            {
                this.@uiOrder.Refresh();
            }
            if (this.@uiItem != null)
            {
                this.@uiItem.Refresh();
            }
            if (this.@uiVisible != null)
            {
                this.@uiVisible.Refresh();
            }
        }

        private void OnPropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            if (e.PropertyName == "HashValue")
            {
                this.CalcCRC();
            }
        }
    }
}
