﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using nw.g3d.nw4f_3dif;
using Opal.Security.Cryptography;
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.G3dTool.Entities.Internal;

namespace Nintendo.G3dTool.Entities
{
    public class OriginalTexsrtAnim : ObservableEntity<original_texsrt_animType>, IDeepCopyable<OriginalTexsrtAnim>, IDeepCopyFrom<OriginalTexsrtAnim>
    {
        private readonly ObservableList<OriginalTexsrtAnimTarget> @originalTexsrtAnimTargets = new ObservableList<OriginalTexsrtAnimTarget>();
        private string @hint = string.Empty;
        private original_texsrt_anim_modeType @mode;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OriginalTexsrtAnim()
        {
            this.@originalTexsrtAnimTargets.CollectionChanged += OnCollectionChanged<OriginalTexsrtAnimTarget>;
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public OriginalTexsrtAnim(OriginalTexsrtAnim source)
            : this()
        {
            this.DeepCopyFrom(source);
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public OriginalTexsrtAnim(original_texsrt_animType source)
        {
            this.@originalTexsrtAnimTargets.CollectionChanged += OnCollectionChanged<OriginalTexsrtAnimTarget>;
            if (source.@original_texsrt_anim_target != null)
            {
                this.@originalTexsrtAnimTargets.Clear();
                foreach (var elem in source.@original_texsrt_anim_target)
                {
                    this.@originalTexsrtAnimTargets.Add(new OriginalTexsrtAnimTarget(elem));
                }
            }
            this.@hint = source.@hint;
            this.@mode = source.@mode;
        }

        public ObservableList<OriginalTexsrtAnimTarget> OriginalTexsrtAnimTargets
        {
            get
            {
                return this.@originalTexsrtAnimTargets;
            }
        }

        public string Hint
        {
            get
            {
                return this.@hint;
            }

            set
            {
                if (this.@hint == value)
                {
                    return;
                }

                Ensure.Argument.NotNull(value);
                this.SetProperty(ref this.@hint, value, () => this.CalcCRC());
            }
        }

        public original_texsrt_anim_modeType Mode
        {
            get
            {
                return this.@mode;
            }

            set
            {
                if (this.@mode == value)
                {
                    return;
                }

                this.SetProperty(ref this.@mode, value, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override original_texsrt_animType CreateSerializableData()
        {
            var writeData = new original_texsrt_animType();
            if (this.@OriginalTexsrtAnimTargets.Count > 0)
            {
                writeData.@original_texsrt_anim_target = this.@originalTexsrtAnimTargets.Select(x => x.CreateSerializableData()).Where(x => x != null).ToArray();
                if (writeData.@original_texsrt_anim_target.Length == 0)
                {
                    writeData.@original_texsrt_anim_target = null;
                }
            }
            writeData.@hint = this.Hint;
            writeData.@mode = this.Mode;
            return writeData;
        }

        /// <summary>
        /// 現在のインスタンスをディープコピーで複製した新規インスタンスを返します。
        /// </summary>
        OriginalTexsrtAnim IDeepCopyable<OriginalTexsrtAnim>.DeepCopy()
        {
            return new OriginalTexsrtAnim(this);
        }

        /// <summary>
        /// 入力ファイルからディープコピーします。
        /// </summary>
        /// <param name="source">コピー元となる入力ファイルです。</param>
        public void DeepCopyFrom(OriginalTexsrtAnim source)
        {
            CopyElements(source.@originalTexsrtAnimTargets, this.@originalTexsrtAnimTargets);
            this.@hint = source.@hint;
            this.@mode = source.@mode;
        }

        /// <summary>
        /// エンティティの CRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRC の値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            foreach (var elem in this.OriginalTexsrtAnimTargets)
            {
                buffers.AddRange(BitConverter.GetBytes(elem.HashValue));
            }
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Hint)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Mode)));
            return crc.ComputeHashUInt32(buffers.ToArray());
        }

        /// <summary>
        /// 自動計算フラグを設定します。(内部処理用）
        /// </summary>
        protected override void SetAutoCalcFlagInternal()
        {
            foreach (var elem in this.@originalTexsrtAnimTargets)
            {
                elem.AutoCalc = this.AutoCalc;
            }
        }

        /// <summary>
        /// エンティティの状態をリセットします。(内部処理用）
        /// </summary>
        protected override void ResetInternal()
        {
            foreach (var elem in this.@originalTexsrtAnimTargets)
            {
                elem.Reset();
            }
        }

        /// <summary>
        /// エンティティの状態を更新します。(内部処理用）
        /// </summary>
        protected override void RefreshInternal()
        {
            foreach (var elem in this.@originalTexsrtAnimTargets)
            {
                elem.Refresh();
            }
        }

        private void OnPropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            if (e.PropertyName == "HashValue")
            {
                this.CalcCRC();
            }
        }
    }
}
