﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using nw.g3d.nw4f_3dif;
using Opal.Security.Cryptography;
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.G3dTool.Entities.Internal;

namespace Nintendo.G3dTool.Entities
{
    public class LightAnim : ObservableEntity<light_animType>, IChildEntity, IDeepCopyable<LightAnim>, IDeepCopyFrom<LightAnim>
    {
        private readonly ObservableDictionary<light_anim_target_targetType, LightAnimTarget> @lightAnimTargets = new ObservableDictionary<light_anim_target_targetType, LightAnimTarget>();
        private readonly ObservableList<UserData> @userDatas = new ObservableList<UserData>();
        private readonly Comment @comment = new Comment();
        private readonly ToolData @toolData = new ToolData();
        private readonly UserToolData @userToolData = new UserToolData();
        private string @lightName = string.Empty;
        private int @frameCount;
        private bool @loop;
        private string @type = string.Empty;
        private string @distAttnFunc = string.Empty;
        private string @angleAttnFunc = string.Empty;
        private SceneAnim parent = null;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public LightAnim()
        {
            this.@lightAnimTargets.CollectionChanged += OnDictionaryChanged<light_anim_target_targetType, LightAnimTarget>;
            this.@lightAnimTargets.Add(light_anim_target_targetType.enable, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.enable
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.position_x, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.position_x
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.position_y, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.position_y
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.position_z, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.position_z
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.direction_x, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.direction_x
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.direction_y, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.direction_y
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.direction_z, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.direction_z
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.aim_x, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.aim_x
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.aim_y, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.aim_y
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.aim_z, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.aim_z
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.dist_attn_start, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.dist_attn_start
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.dist_attn_end, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.dist_attn_end
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.angle_attn_start, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.angle_attn_start
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.angle_attn_end, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.angle_attn_end
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.color0_r, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.color0_r
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.color0_g, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.color0_g
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.color0_b, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.color0_b
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.color1_r, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.color1_r
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.color1_g, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.color1_g
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.color1_b, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.color1_b
            });
            this.@userDatas.CollectionChanged += OnCollectionChanged<UserData>;
            this.@comment.PropertyChanged += this.OnPropertyChanged;
            this.@toolData.PropertyChanged += this.OnPropertyChanged;
            this.@userToolData.PropertyChanged += this.OnPropertyChanged;
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public LightAnim(LightAnim source)
            : this()
        {
            this.DeepCopyFrom(source);
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public LightAnim(light_animType source)
        {
            this.@lightAnimTargets.CollectionChanged += OnDictionaryChanged<light_anim_target_targetType, LightAnimTarget>;
            this.@lightAnimTargets.Add(light_anim_target_targetType.enable, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.enable
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.position_x, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.position_x
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.position_y, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.position_y
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.position_z, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.position_z
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.direction_x, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.direction_x
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.direction_y, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.direction_y
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.direction_z, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.direction_z
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.aim_x, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.aim_x
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.aim_y, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.aim_y
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.aim_z, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.aim_z
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.dist_attn_start, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.dist_attn_start
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.dist_attn_end, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.dist_attn_end
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.angle_attn_start, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.angle_attn_start
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.angle_attn_end, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.angle_attn_end
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.color0_r, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.color0_r
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.color0_g, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.color0_g
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.color0_b, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.color0_b
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.color1_r, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.color1_r
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.color1_g, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.color1_g
            });
            this.@lightAnimTargets.Add(light_anim_target_targetType.color1_b, new LightAnimTarget()
            {
                Target = light_anim_target_targetType.color1_b
            });
            this.@userDatas.CollectionChanged += OnCollectionChanged<UserData>;
            if (source.light_anim_target != null)
            {
                foreach (var elem in source.light_anim_target)
                {
                    this.@lightAnimTargets[elem.target] = new LightAnimTarget(elem);
                }
            }
            if (source.@user_data_array != null)
            {
                this.@userDatas.Clear();
                foreach (var elem in source.@user_data_array.Items)
                {
                    this.@userDatas.Add(DataModelConverter.Convert(elem));
                }
            }
            if (source.@comment != null)
            {
                this.@comment = new Comment(source.@comment);
            }
            else
            {
                this.@comment = new Comment();
            }
            if (source.@tool_data != null)
            {
                this.@toolData = new ToolData(source.@tool_data);
            }
            else
            {
                this.@toolData = new ToolData();
            }
            if (source.@user_tool_data != null)
            {
                this.@userToolData = new UserToolData(source.@user_tool_data);
            }
            else
            {
                this.@userToolData = new UserToolData();
            }
            this.@lightName = source.@light_name;
            this.@frameCount = source.@frame_count;
            this.@loop = source.@loop;
            this.@type = source.@type;
            this.@distAttnFunc = source.@dist_attn_func;
            this.@angleAttnFunc = source.@angle_attn_func;
            this.@comment.PropertyChanged += this.OnPropertyChanged;
            this.@toolData.PropertyChanged += this.OnPropertyChanged;
            this.@userToolData.PropertyChanged += this.OnPropertyChanged;
        }

        public IReadOnlyDictionary<light_anim_target_targetType, LightAnimTarget> LightAnimTargets
        {
            get
            {
                return this.@lightAnimTargets as IReadOnlyDictionary<light_anim_target_targetType, LightAnimTarget>;
            }
        }

        public ObservableList<UserData> UserDatas
        {
            get
            {
                return this.@userDatas;
            }
        }

        public Comment Comment
        {
            get
            {
                return this.@comment;
            }
        }

        public ToolData ToolData
        {
            get
            {
                return this.@toolData;
            }
        }

        public UserToolData UserToolData
        {
            get
            {
                return this.@userToolData;
            }
        }

        public string LightName
        {
            get
            {
                return this.@lightName;
            }

            set
            {
                if (this.@lightName == value)
                {
                    return;
                }

                Ensure.Argument.NotNull(value);
                this.SetProperty(ref this.@lightName, value, () => this.CalcCRC());
            }
        }

        public int FrameCount
        {
            get
            {
                return this.@frameCount;
            }

            set
            {
                if (this.@frameCount == value)
                {
                    return;
                }

                this.SetProperty(ref this.@frameCount, value, () => this.CalcCRC());
            }
        }

        public bool Loop
        {
            get
            {
                return this.@loop;
            }

            set
            {
                if (this.@loop == value)
                {
                    return;
                }

                this.SetProperty(ref this.@loop, value, () => this.CalcCRC());
            }
        }

        public string Type
        {
            get
            {
                return this.@type;
            }

            set
            {
                if (this.@type == value)
                {
                    return;
                }

                Ensure.Argument.NotNull(value);
                this.SetProperty(ref this.@type, value, () => this.CalcCRC());
            }
        }

        public string DistAttnFunc
        {
            get
            {
                return this.@distAttnFunc;
            }

            set
            {
                if (this.@distAttnFunc == value)
                {
                    return;
                }

                Ensure.Argument.NotNull(value);
                this.SetProperty(ref this.@distAttnFunc, value, () => this.CalcCRC());
            }
        }

        public string AngleAttnFunc
        {
            get
            {
                return this.@angleAttnFunc;
            }

            set
            {
                if (this.@angleAttnFunc == value)
                {
                    return;
                }

                Ensure.Argument.NotNull(value);
                this.SetProperty(ref this.@angleAttnFunc, value, () => this.CalcCRC());
            }
        }

        IEntity IChildEntity.Parent
        {
            get
            {
                return this.parent as IEntity;
            }

            set
            {
                if (this.parent == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? value is SceneAnim : true);
                this.SetProperty(ref this.parent, value as SceneAnim, () => this.CalcCRC());
            }
        }

        public SceneAnim Parent
        {
            get
            {
                return this.parent;
            }
        }

        Type IChildEntity.ParentType
        {
            get
            {
                return typeof(SceneAnim);
            }
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override light_animType CreateSerializableData()
        {
            var writeData = new light_animType();
            writeData.light_anim_target = this.LightAnimTargets
                .Where(x => x.Value.Curve != null)
                .Select(x => x.Value.CreateSerializableData())
                .ToArray();
            if (writeData.light_anim_target.Length == 0)
            {
                writeData.light_anim_target = null;
            }
            if (this.@UserDatas.Count > 0)
            {
                writeData.@user_data_array = new user_data_arrayType();
                writeData.@user_data_array.Items = this.@userDatas.Select(x => x.CreateSerializableData()).Where(x => x != null).ToArray();
                if (writeData.@user_data_array.Items.Length == 0)
                {
                    writeData.@user_data_array = null;
                }
            }
            writeData.@comment = this.@comment.CreateSerializableData() as commentType;
            writeData.@tool_data = this.@toolData.CreateSerializableData() as tool_dataType;
            writeData.@user_tool_data = this.@userToolData.CreateSerializableData() as user_tool_dataType;
            writeData.@light_name = this.LightName;
            writeData.@frame_count = this.FrameCount;
            writeData.@loop = this.Loop;
            writeData.@type = this.Type;
            writeData.@dist_attn_func = this.DistAttnFunc;
            writeData.@angle_attn_func = this.AngleAttnFunc;
            return writeData;
        }

        /// <summary>
        /// 現在のインスタンスをディープコピーで複製した新規インスタンスを返します。
        /// </summary>
        LightAnim IDeepCopyable<LightAnim>.DeepCopy()
        {
            return new LightAnim(this);
        }

        /// <summary>
        /// 入力ファイルからディープコピーします。
        /// </summary>
        /// <param name="source">コピー元となる入力ファイルです。</param>
        public void DeepCopyFrom(LightAnim source)
        {
            CopyElements(source.@lightAnimTargets, this.@lightAnimTargets);
            CopyElements(source.@userDatas, this.@userDatas);
            this.@comment.DeepCopyFrom(source.@comment);
            this.@toolData.DeepCopyFrom(source.@toolData);
            this.@userToolData.DeepCopyFrom(source.@userToolData);
            this.@lightName = source.@lightName;
            this.@frameCount = source.@frameCount;
            this.@loop = source.@loop;
            this.@type = source.@type;
            this.@distAttnFunc = source.@distAttnFunc;
            this.@angleAttnFunc = source.@angleAttnFunc;
        }

        /// <summary>
        /// エンティティの CRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRC の値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            foreach (var elem in this.LightAnimTargets)
            {
                buffers.AddRange(BitConverter.GetBytes(elem.Value.HashValue));
            }
            foreach (var elem in this.UserDatas)
            {
                buffers.AddRange(BitConverter.GetBytes(elem.HashValue));
            }
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Comment.HashValue)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.ToolData.HashValue)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UserToolData.HashValue)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.LightName)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.FrameCount)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Loop)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Type)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.DistAttnFunc)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.AngleAttnFunc)));
            return crc.ComputeHashUInt32(buffers.ToArray());
        }

        /// <summary>
        /// 自動計算フラグを設定します。(内部処理用）
        /// </summary>
        protected override void SetAutoCalcFlagInternal()
        {
            foreach (var elem in this.@lightAnimTargets)
            {
                elem.Value.AutoCalc = this.AutoCalc;
            }
            foreach (var elem in this.@userDatas)
            {
                elem.AutoCalc = this.AutoCalc;
            }
            this.@comment.AutoCalc = this.AutoCalc;
            this.@toolData.AutoCalc = this.AutoCalc;
            this.@userToolData.AutoCalc = this.AutoCalc;
        }

        /// <summary>
        /// エンティティの状態をリセットします。(内部処理用）
        /// </summary>
        protected override void ResetInternal()
        {
            foreach (var elem in this.@lightAnimTargets)
            {
                elem.Value.Reset();
            }
            foreach (var elem in this.@userDatas)
            {
                elem.Reset();
            }
            this.@comment.Reset();
            this.@toolData.Reset();
            this.@userToolData.Reset();
        }

        /// <summary>
        /// エンティティの状態を更新します。(内部処理用）
        /// </summary>
        protected override void RefreshInternal()
        {
            foreach (var elem in this.@lightAnimTargets)
            {
                elem.Value.Refresh();
            }
            foreach (var elem in this.@userDatas)
            {
                elem.Refresh();
            }
            this.@comment.Refresh();
            this.@toolData.Refresh();
            this.@userToolData.Refresh();
        }

        private void OnPropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            if (e.PropertyName == "HashValue")
            {
                this.CalcCRC();
            }
        }
    }
}
