﻿using Nintendo.ToolFoundation.Contracts;
using nw.g3d.nw4f_3dif;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.G3dTool.Entities.Internal
{
    public static class StreamUtility
    {
        public static Stream CreateStream(Stream stream)
        {
            switch (stream.Type)
            {
                case stream_typeType.@byte:
                    return new StreamByte(stream as StreamByte);
                case stream_typeType.@float:
                    return new StreamFloat(stream as StreamFloat);
                case stream_typeType.@int:
                    return new StreamInt(stream as StreamInt);
                case stream_typeType.@string:
                    return new StreamString(stream as StreamString);
                case stream_typeType.wstring:
                    return new StreamWstring(stream as StreamWstring);
                default:
                    throw new NotImplementedException();
            }
        }

        public static Stream CreateStream<TValue>(vtx_attrib_typeType type, IEnumerable<TValue> streamData)
        {
            int column = VtxAttrib.EstimateElementCountPerVertex(type);
            Ensure.Argument.AreEqual(0, streamData.Count() % column);
            switch (type)
            {
                case vtx_attrib_typeType.@float:
                case vtx_attrib_typeType.@float2:
                case vtx_attrib_typeType.@float3:
                case vtx_attrib_typeType.@float4:
                    return new StreamFloat(streamData as IEnumerable<float>, column);
                case vtx_attrib_typeType.@int:
                case vtx_attrib_typeType.@int2:
                case vtx_attrib_typeType.@int3:
                case vtx_attrib_typeType.@int4:
                    return new StreamInt(streamData as IEnumerable<int>, column);
                case vtx_attrib_typeType.@uint:
                case vtx_attrib_typeType.@uint2:
                case vtx_attrib_typeType.@uint3:
                case vtx_attrib_typeType.@uint4:
                    return new StreamInt((streamData as IEnumerable<uint>).Select(x => (int)x), column);
                default:
                    throw new NotImplementedException();
            }
        }
    }
}
