﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.G3dTool.Entities.Internal
{
    internal static class MatrixExtensions
    {
        internal static Float4x4 Inverse(this Float4x4 source)
        {
            Float4x4 inverse = new Float4x4();

            for (int i = 0; i < 4; i++)
            {
                float max = 0.0f;
                int pivot = i;

                // ピボット選択
                for (int k = i; k < 4; k++)
                {
                    float ftmp = Math.Abs(source[k, i]);
                    if (ftmp > max)
                    {
                        max = ftmp;
                        pivot = k;
                    }
                }

                // 逆行列は存在しない
                if (max == 0f)
                {
                    return null;
                }

                // 行の交換
                if (pivot != i)
                {
                    SwapRow(source, i, pivot);
                    SwapRow(inverse, i, pivot);
                }

                float w = 1.0f / source[i, i];

                for (int j = 0; j < 4; j++)
                {
                    source[i, j] *= w;
                    inverse[i, j] *= w;
                }

                for (int k = 0; k < 4; k++)
                {
                    if (k == i)
                    {
                        continue;
                    }

                    w = source[k, i];
                    for (int j = 0; j < 4; j++)
                    {
                        source[k, j] -= source[i, j] * w;
                        inverse[k, j] -= inverse[i, j] * w;
                    }
                }
            }

            return inverse;
        }

        // 行の交換。
        private static void SwapRow(this IMatrix mtx, int r1, int r2)
        {
            if (r1 == r2)
            {
                return;
            }

            for (int i = 0; i < mtx.ColumnCount; i++)
            {
                float temp = mtx[r1, i];
                mtx[r1, i] = mtx[r2, i];
                mtx[r2, i] = temp;
            }
        }
    }
}
