﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------



using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using nw.g3d.nw4f_3dif;
using Opal.Security.Cryptography;
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.G3dTool.Entities.Internal;

namespace Nintendo.G3dTool.Entities.Internal
{
    internal static class DataModelConverter
    {
        internal static ShaderParam Convert(shader_paramType source)
        {
            switch (source.type)
            {
                case shader_param_typeType.@bool: return new ShaderParamBool(source);
                case shader_param_typeType.@bool2: return new ShaderParamBool2(source);
                case shader_param_typeType.@bool3: return new ShaderParamBool3(source);
                case shader_param_typeType.@bool4: return new ShaderParamBool4(source);
                case shader_param_typeType.@int: return new ShaderParamInt(source);
                case shader_param_typeType.@int2: return new ShaderParamInt2(source);
                case shader_param_typeType.@int3: return new ShaderParamInt3(source);
                case shader_param_typeType.@int4: return new ShaderParamInt4(source);
                case shader_param_typeType.@uint: return new ShaderParamUint(source);
                case shader_param_typeType.@uint2: return new ShaderParamUint2(source);
                case shader_param_typeType.@uint3: return new ShaderParamUint3(source);
                case shader_param_typeType.@uint4: return new ShaderParamUint4(source);
                case shader_param_typeType.@float: return new ShaderParamFloat(source);
                case shader_param_typeType.@float2: return new ShaderParamFloat2(source);
                case shader_param_typeType.@float3: return new ShaderParamFloat3(source);
                case shader_param_typeType.@float4: return new ShaderParamFloat4(source);
                case shader_param_typeType.@float2x2: return new ShaderParamFloat2x2(source);
                case shader_param_typeType.@float2x3: return new ShaderParamFloat2x3(source);
                case shader_param_typeType.@float2x4: return new ShaderParamFloat2x4(source);
                case shader_param_typeType.@float3x2: return new ShaderParamFloat3x2(source);
                case shader_param_typeType.@float3x3: return new ShaderParamFloat3x3(source);
                case shader_param_typeType.@float3x4: return new ShaderParamFloat3x4(source);
                case shader_param_typeType.@float4x2: return new ShaderParamFloat4x2(source);
                case shader_param_typeType.@float4x3: return new ShaderParamFloat4x3(source);
                case shader_param_typeType.@float4x4: return new ShaderParamFloat4x4(source);
                case shader_param_typeType.@srt2d: return new ShaderParamSrt2d(source);
                case shader_param_typeType.@srt3d: return new ShaderParamSrt3d(source);
                case shader_param_typeType.@texsrt: return new ShaderParamTexsrt(source);
                default:
                    ToolFoundation.Contracts.Ensure.Operation.Fail("Unexpected default");
                    return null;
            }
        }

        internal static ShaderParam Convert(UniformVar source)
        {
            switch (source.Type)
            {
                case shader_param_typeType.@bool: return new ShaderParamBool(source);
                case shader_param_typeType.@bool2: return new ShaderParamBool2(source);
                case shader_param_typeType.@bool3: return new ShaderParamBool3(source);
                case shader_param_typeType.@bool4: return new ShaderParamBool4(source);
                case shader_param_typeType.@int: return new ShaderParamInt(source);
                case shader_param_typeType.@int2: return new ShaderParamInt2(source);
                case shader_param_typeType.@int3: return new ShaderParamInt3(source);
                case shader_param_typeType.@int4: return new ShaderParamInt4(source);
                case shader_param_typeType.@uint: return new ShaderParamUint(source);
                case shader_param_typeType.@uint2: return new ShaderParamUint2(source);
                case shader_param_typeType.@uint3: return new ShaderParamUint3(source);
                case shader_param_typeType.@uint4: return new ShaderParamUint4(source);
                case shader_param_typeType.@float: return new ShaderParamFloat(source);
                case shader_param_typeType.@float2: return new ShaderParamFloat2(source);
                case shader_param_typeType.@float3: return new ShaderParamFloat3(source);
                case shader_param_typeType.@float4: return new ShaderParamFloat4(source);
                case shader_param_typeType.@float2x2: return new ShaderParamFloat2x2(source);
                case shader_param_typeType.@float2x3: return new ShaderParamFloat2x3(source);
                case shader_param_typeType.@float2x4: return new ShaderParamFloat2x4(source);
                case shader_param_typeType.@float3x2: return new ShaderParamFloat3x2(source);
                case shader_param_typeType.@float3x3: return new ShaderParamFloat3x3(source);
                case shader_param_typeType.@float3x4: return new ShaderParamFloat3x4(source);
                case shader_param_typeType.@float4x2: return new ShaderParamFloat4x2(source);
                case shader_param_typeType.@float4x3: return new ShaderParamFloat4x3(source);
                case shader_param_typeType.@float4x4: return new ShaderParamFloat4x4(source);
                case shader_param_typeType.@srt2d: return new ShaderParamSrt2d(source);
                case shader_param_typeType.@srt3d: return new ShaderParamSrt3d(source);
                case shader_param_typeType.@texsrt: return new ShaderParamTexsrt(source);
                default:
                    ToolFoundation.Contracts.Ensure.Operation.Fail("Unexpected default");
                    return null;
            }
        }

        internal static ShaderParam Convert(shader_param_typeType type)
        {
            switch (type)
            {
                case shader_param_typeType.@bool: return new ShaderParamBool();
                case shader_param_typeType.@bool2: return new ShaderParamBool2();
                case shader_param_typeType.@bool3: return new ShaderParamBool3();
                case shader_param_typeType.@bool4: return new ShaderParamBool4();
                case shader_param_typeType.@int: return new ShaderParamInt();
                case shader_param_typeType.@int2: return new ShaderParamInt2();
                case shader_param_typeType.@int3: return new ShaderParamInt3();
                case shader_param_typeType.@int4: return new ShaderParamInt4();
                case shader_param_typeType.@uint: return new ShaderParamUint();
                case shader_param_typeType.@uint2: return new ShaderParamUint2();
                case shader_param_typeType.@uint3: return new ShaderParamUint3();
                case shader_param_typeType.@uint4: return new ShaderParamUint4();
                case shader_param_typeType.@float: return new ShaderParamFloat();
                case shader_param_typeType.@float2: return new ShaderParamFloat2();
                case shader_param_typeType.@float3: return new ShaderParamFloat3();
                case shader_param_typeType.@float4: return new ShaderParamFloat4();
                case shader_param_typeType.@float2x2: return new ShaderParamFloat2x2();
                case shader_param_typeType.@float2x3: return new ShaderParamFloat2x3();
                case shader_param_typeType.@float2x4: return new ShaderParamFloat2x4();
                case shader_param_typeType.@float3x2: return new ShaderParamFloat3x2();
                case shader_param_typeType.@float3x3: return new ShaderParamFloat3x3();
                case shader_param_typeType.@float3x4: return new ShaderParamFloat3x4();
                case shader_param_typeType.@float4x2: return new ShaderParamFloat4x2();
                case shader_param_typeType.@float4x3: return new ShaderParamFloat4x3();
                case shader_param_typeType.@float4x4: return new ShaderParamFloat4x4();
                case shader_param_typeType.@srt2d: return new ShaderParamSrt2d();
                case shader_param_typeType.@srt3d: return new ShaderParamSrt3d();
                case shader_param_typeType.@texsrt: return new ShaderParamTexsrt();
                default:
                    ToolFoundation.Contracts.Ensure.Operation.Fail("Unexpected default");
                    return null;
            }
        }

        internal static Stream Convert(streamType source)
        {
            switch (source.type)
            {
                case stream_typeType.@float: return new StreamFloat(source);
                case stream_typeType.@int: return new StreamInt(source);
                case stream_typeType.@byte: return new StreamByte(source);
                case stream_typeType.@string: return new StreamString(source);
                case stream_typeType.@wstring: return new StreamWstring(source);
                default:
                    ToolFoundation.Contracts.Ensure.Operation.Fail("Unexpected default");
                    return null;
            }
        }

        internal static RenderInfo Convert(render_infoType source)
        {
            switch (source.type)
            {
                case render_info_typeType.@int: return new RenderInfoInt(source);
                case render_info_typeType.@float: return new RenderInfoFloat(source);
                case render_info_typeType.@string: return new RenderInfoString(source);
                default:
                    ToolFoundation.Contracts.Ensure.Operation.Fail("Unexpected default");
                    return null;
            }
        }

        internal static RenderInfoSlot Convert(render_info_slotType source)
        {
            switch (source.type)
            {
                case render_info_slot_typeType.@int: return new RenderInfoSlotInt(source);
                case render_info_slot_typeType.@float: return new RenderInfoSlotFloat(source);
                case render_info_slot_typeType.@string: return new RenderInfoSlotString(source);
                default:
                    ToolFoundation.Contracts.Ensure.Operation.Fail("Unexpected default");
                    return null;
            }
        }

        internal static RenderInfo Convert(RenderInfoSlot source)
        {
            switch (source.Type)
            {
                case render_info_slot_typeType.@int: return new RenderInfoInt(source);
                case render_info_slot_typeType.@float: return new RenderInfoFloat(source);
                case render_info_slot_typeType.@string: return new RenderInfoString(source);
                default:
                    ToolFoundation.Contracts.Ensure.Operation.Fail("Unexpected default");
                    return null;
            }
        }

        internal static UserData Convert(user_dataType source)
        {
            if (source.Item is user_intType)
            {
                return new UserDataInt(source);
            }
            else if (source.Item is user_floatType)
            {
                return new UserDataFloat(source);
            }
            else if (source.Item is user_stringType)
            {
                return new UserDataString(source);
            }
            else if (source.Item is user_wstringType)
            {
                return new UserDataWstring(source);
            }
            else if (source.Item is user_streamType)
            {
                return new UserDataStream(source);
            }
            else
            {
                ToolFoundation.Contracts.Ensure.Operation.Fail("Unexpected else");
                return null;
            }
        }

        internal static ICurve ConvertCurve(object source)
        {
            if (source is hermite_curveType)
            {
                return new HermiteCurve(source as hermite_curveType);
            }
            else if (source is step_curveType)
            {
                return new StepCurve(source as step_curveType);
            }
            else if (source is linear_curveType)
            {
                return new LinearCurve(source as linear_curveType);
            }
            else
            {
                ToolFoundation.Contracts.Ensure.Operation.Fail("Unexpected else");
                return null;
            }
        }
    }
}
