﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using nw.g3d.nw4f_3dif;
using Opal.Security.Cryptography;
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.G3dTool.Entities.Internal;

namespace Nintendo.G3dTool.Entities
{
    public class BoneVisibilityAnim : RootEntity<bone_visibility_animType>, IDeepCopyable<BoneVisibilityAnim>, IDeepCopyFrom<BoneVisibilityAnim>, IToolData
    {
        private readonly ObservableList<ProcessLog> @processLogs = new ObservableList<ProcessLog>();
        private readonly BoneVisibilityAnimInfo @boneVisibilityAnimInfo = new BoneVisibilityAnimInfo();
        private readonly ObservableList<BoneVisBoneAnim> @boneVisBoneAnims = new ObservableList<BoneVisBoneAnim>();
        private readonly ObservableList<UserData> @userDatas = new ObservableList<UserData>();
        private readonly ObservableList<Stream> @streams = new ObservableList<Stream>();
        private readonly Comment @comment = new Comment();
        private readonly ToolData @toolData = new ToolData();
        private readonly UserToolData @userToolData = new UserToolData();
        private bone_visibility_anim_versionType @version;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        internal BoneVisibilityAnim()
        {
            this.@processLogs.CollectionChanged += OnCollectionChanged<ProcessLog>;
            this.@boneVisibilityAnimInfo.PropertyChanged += this.OnPropertyChanged;
            this.@boneVisBoneAnims.CollectionChanged += OnCollectionChanged<BoneVisBoneAnim>;
            this.@userDatas.CollectionChanged += OnCollectionChanged<UserData>;
            this.@streams.CollectionChanged += OnCollectionChanged<Stream>;
            this.@comment.PropertyChanged += this.OnPropertyChanged;
            this.@toolData.PropertyChanged += this.OnPropertyChanged;
            this.@userToolData.PropertyChanged += this.OnPropertyChanged;
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public BoneVisibilityAnim(BoneVisibilityAnim source)
            : this()
        {
            this.DeepCopyFrom(source);
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public BoneVisibilityAnim(bone_visibility_animType source)
        {
            this.@processLogs.CollectionChanged += OnCollectionChanged<ProcessLog>;
            this.@boneVisBoneAnims.CollectionChanged += OnCollectionChanged<BoneVisBoneAnim>;
            this.@userDatas.CollectionChanged += OnCollectionChanged<UserData>;
            this.@streams.CollectionChanged += OnCollectionChanged<Stream>;
            if (source.@process_log_array != null)
            {
                this.@processLogs.Clear();
                foreach (var elem in source.@process_log_array.Items)
                {
                    this.@processLogs.Add(new ProcessLog(elem));
                }
            }
            if (source.@bone_visibility_anim_info != null)
            {
                this.@boneVisibilityAnimInfo = new BoneVisibilityAnimInfo(source.@bone_visibility_anim_info);
            }
            else
            {
                this.@boneVisibilityAnimInfo = new BoneVisibilityAnimInfo();
            }
            if (source.@bone_vis_bone_anim_array != null)
            {
                this.@boneVisBoneAnims.Clear();
                foreach (var elem in source.@bone_vis_bone_anim_array.Items)
                {
                    this.@boneVisBoneAnims.Add(new BoneVisBoneAnim(elem));
                }
            }
            if (source.@user_data_array != null)
            {
                this.@userDatas.Clear();
                foreach (var elem in source.@user_data_array.Items)
                {
                    this.@userDatas.Add(DataModelConverter.Convert(elem));
                }
            }
            if (source.@stream_array != null)
            {
                this.@streams.Clear();
                foreach (var elem in source.@stream_array.Items)
                {
                    this.@streams.Add(DataModelConverter.Convert(elem));
                }
            }
            if (source.@comment != null)
            {
                this.@comment = new Comment(source.@comment);
            }
            else
            {
                this.@comment = new Comment();
            }
            if (source.@tool_data != null)
            {
                this.@toolData = new ToolData(source.@tool_data);
            }
            else
            {
                this.@toolData = new ToolData();
            }
            if (source.@user_tool_data != null)
            {
                this.@userToolData = new UserToolData(source.@user_tool_data);
            }
            else
            {
                this.@userToolData = new UserToolData();
            }
            this.@version = source.@version;
            this.@boneVisibilityAnimInfo.PropertyChanged += this.OnPropertyChanged;
            this.@comment.PropertyChanged += this.OnPropertyChanged;
            this.@toolData.PropertyChanged += this.OnPropertyChanged;
            this.@userToolData.PropertyChanged += this.OnPropertyChanged;
            this.ResolveInternalReferences();
        }

        public ObservableList<ProcessLog> ProcessLogs
        {
            get
            {
                return this.@processLogs;
            }
        }

        public BoneVisibilityAnimInfo BoneVisibilityAnimInfo
        {
            get
            {
                return this.@boneVisibilityAnimInfo;
            }
        }

        public ObservableList<BoneVisBoneAnim> BoneVisBoneAnims
        {
            get
            {
                return this.@boneVisBoneAnims;
            }
        }

        public ObservableList<UserData> UserDatas
        {
            get
            {
                return this.@userDatas;
            }
        }

        public override ObservableList<Stream> Streams
        {
            get
            {
                return this.@streams;
            }
        }

        public Comment Comment
        {
            get
            {
                return this.@comment;
            }
        }

        public ToolData ToolData
        {
            get
            {
                return this.@toolData;
            }
        }

        public UserToolData UserToolData
        {
            get
            {
                return this.@userToolData;
            }
        }

        public bone_visibility_anim_versionType Version
        {
            get
            {
                return this.@version;
            }

            set
            {
                if (this.@version == value)
                {
                    return;
                }

                this.SetProperty(ref this.@version, value, () => this.CalcCRC());
            }
        }

        public override void ResolveInternalReferences()
        {
            if (this.Streams.Count > 0)
            {
                foreach (var target in this.boneVisBoneAnims)
                {
                    if (target.Curve != null)
                    {
                        target.Curve.Stream = this.Streams[(target.Curve as IStreamIndex).StreamIndex];
                    }
                }
            }
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override bone_visibility_animType CreateSerializableData()
        {
            var writeData = new bone_visibility_animType();
            if (this.@ProcessLogs.Count > 0)
            {
                writeData.@process_log_array = new process_log_arrayType();
                writeData.@process_log_array.Items = this.@processLogs.Select(x => x.CreateSerializableData()).Where(x => x != null).ToArray();
                if (writeData.@process_log_array.Items.Length == 0)
                {
                    writeData.@process_log_array = null;
                }
            }
            writeData.@bone_visibility_anim_info = this.@boneVisibilityAnimInfo.CreateSerializableData() as bone_visibility_anim_infoType;
            if (this.@BoneVisBoneAnims.Count > 0)
            {
                writeData.@bone_vis_bone_anim_array = new bone_vis_bone_anim_arrayType();
                writeData.@bone_vis_bone_anim_array.Items = this.@boneVisBoneAnims.Select(x => x.CreateSerializableData()).Where(x => x != null).ToArray();
                if (writeData.@bone_vis_bone_anim_array.Items.Length == 0)
                {
                    writeData.@bone_vis_bone_anim_array = null;
                }
            }
            if (this.@UserDatas.Count > 0)
            {
                writeData.@user_data_array = new user_data_arrayType();
                writeData.@user_data_array.Items = this.@userDatas.Select(x => x.CreateSerializableData()).Where(x => x != null).ToArray();
                if (writeData.@user_data_array.Items.Length == 0)
                {
                    writeData.@user_data_array = null;
                }
            }
            if (this.IsStreamSerializationEnabled)
            {
                if (this.@Streams.Count > 0)
                {
                    writeData.@stream_array = new stream_arrayType();
                    writeData.@stream_array.Items = this.@streams.Select(x => x.CreateSerializableData()).Where(x => x != null).ToArray();
                    if (writeData.@stream_array.Items.Length == 0)
                    {
                        writeData.@stream_array = null;
                    }
                }
            }
            writeData.@comment = this.@comment.CreateSerializableData() as commentType;
            writeData.@tool_data = this.@toolData.CreateSerializableData() as tool_dataType;
            writeData.@user_tool_data = this.@userToolData.CreateSerializableData() as user_tool_dataType;
            writeData.@version = this.Version;
            return writeData;
        }

        /// <summary>
        /// 現在のインスタンスをディープコピーで複製した新規インスタンスを返します。
        /// </summary>
        BoneVisibilityAnim IDeepCopyable<BoneVisibilityAnim>.DeepCopy()
        {
            return new BoneVisibilityAnim(this);
        }

        /// <summary>
        /// 入力ファイルからディープコピーします。
        /// </summary>
        /// <param name="source">コピー元となる入力ファイルです。</param>
        public void DeepCopyFrom(BoneVisibilityAnim source)
        {
            CopyElements(source.@processLogs, this.@processLogs);
            this.@boneVisibilityAnimInfo.DeepCopyFrom(source.@boneVisibilityAnimInfo);
            CopyElements(source.@boneVisBoneAnims, this.@boneVisBoneAnims);
            CopyElements(source.@userDatas, this.@userDatas);
            CopyElements(source.@streams, this.@streams);
            this.@comment.DeepCopyFrom(source.@comment);
            this.@toolData.DeepCopyFrom(source.@toolData);
            this.@userToolData.DeepCopyFrom(source.@userToolData);
            this.@version = source.@version;
            this.ResolveInternalReferences();
        }

        private protected override IRootEntity DeepCopy()
        {
            return new BoneVisibilityAnim(this);
        }

        private protected override void DeepCopyFrom(IRootEntity source)
        {
            Nintendo.ToolFoundation.Contracts.Ensure.Argument.True(source is BoneVisibilityAnim);
            this.DeepCopyFrom(source as BoneVisibilityAnim);
        }

        /// <summary>
        /// エンティティの CRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRC の値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            foreach (var elem in this.ProcessLogs)
            {
                buffers.AddRange(BitConverter.GetBytes(elem.HashValue));
            }
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.BoneVisibilityAnimInfo.HashValue)));
            foreach (var elem in this.BoneVisBoneAnims)
            {
                buffers.AddRange(BitConverter.GetBytes(elem.HashValue));
            }
            foreach (var elem in this.UserDatas)
            {
                buffers.AddRange(BitConverter.GetBytes(elem.HashValue));
            }
            foreach (var elem in this.Streams)
            {
                buffers.AddRange(BitConverter.GetBytes(elem.HashValue));
            }
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Comment.HashValue)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.ToolData.HashValue)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.UserToolData.HashValue)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Version)));
            return crc.ComputeHashUInt32(buffers.ToArray());
        }

        /// <summary>
        /// 自動計算フラグを設定します。(内部処理用）
        /// </summary>
        protected override void SetAutoCalcFlagInternal()
        {
            foreach (var elem in this.@processLogs)
            {
                elem.AutoCalc = this.AutoCalc;
            }
            this.@boneVisibilityAnimInfo.AutoCalc = this.AutoCalc;
            foreach (var elem in this.@boneVisBoneAnims)
            {
                elem.AutoCalc = this.AutoCalc;
            }
            foreach (var elem in this.@userDatas)
            {
                elem.AutoCalc = this.AutoCalc;
            }
            foreach (var elem in this.@streams)
            {
                elem.AutoCalc = this.AutoCalc;
            }
            this.@comment.AutoCalc = this.AutoCalc;
            this.@toolData.AutoCalc = this.AutoCalc;
            this.@userToolData.AutoCalc = this.AutoCalc;
        }

        /// <summary>
        /// エンティティの状態をリセットします。(内部処理用）
        /// </summary>
        protected override void ResetInternal()
        {
            foreach (var elem in this.@processLogs)
            {
                elem.Reset();
            }
            this.@boneVisibilityAnimInfo.Reset();
            foreach (var elem in this.@boneVisBoneAnims)
            {
                elem.Reset();
            }
            foreach (var elem in this.@userDatas)
            {
                elem.Reset();
            }
            foreach (var elem in this.@streams)
            {
                elem.Reset();
            }
            this.@comment.Reset();
            this.@toolData.Reset();
            this.@userToolData.Reset();
        }

        /// <summary>
        /// エンティティの状態を更新します。(内部処理用）
        /// </summary>
        protected override void RefreshInternal()
        {
            foreach (var elem in this.@processLogs)
            {
                elem.Refresh();
            }
            this.@boneVisibilityAnimInfo.Refresh();
            foreach (var elem in this.@boneVisBoneAnims)
            {
                elem.Refresh();
            }
            foreach (var elem in this.@userDatas)
            {
                elem.Refresh();
            }
            foreach (var elem in this.@streams)
            {
                elem.Refresh();
            }
            this.@comment.Refresh();
            this.@toolData.Refresh();
            this.@userToolData.Refresh();
        }

        private void OnPropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            if (e.PropertyName == "HashValue")
            {
                this.CalcCRC();
            }
        }
    }
}
