﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

namespace App.Controls
{
    /// <summary>
    /// ＵＩツールチップクラス。
    /// </summary>
    [ToolboxBitmap(typeof(ToolTip))]
    public class UIToolTip : ToolTip
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UIToolTip()
        {
        }

        /// <summary>
        /// コンストラクタ（デザイナ生成用）。
        /// </summary>
        public UIToolTip(IContainer container)
            : base(container)
        {
        }
    }

    /// <summary>
    /// ヒント表示用ツールチップクラス。
    /// </summary>
    public sealed class HintToolTip : UIToolTip
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public HintToolTip()
        {
            Initialize();
        }

        /// <summary>
        /// コンストラクタ（デザイナ生成用）。
        /// </summary>
        public HintToolTip(IContainer container)
            : base(container)
        {
            Initialize();
        }

        /// <summary>
        /// 初期化。
        /// </summary>
        private void Initialize()
        {
            // 勝手に消えないように長めに表示させる
            this.AutoPopDelay = 30000;
            // 親が非アクティブでも表示させる
            this.ShowAlways = true;
        }

        #region デザイナ制御
        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new int AutomaticDelay
        {
            get { return base.AutomaticDelay;  }
            set { base.AutomaticDelay = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new int AutoPopDelay
        {
            get { return base.AutoPopDelay;  }
            set { base.AutoPopDelay = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public new int InitialDelay
        {
            get { return base.InitialDelay;  }
            set { base.InitialDelay = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new bool OwnerDraw
        {
            get { return base.OwnerDraw;  }
            set { base.OwnerDraw = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public new int ReshowDelay
        {
            get { return base.ReshowDelay;  }
            set { base.ReshowDelay = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new bool ShowAlways
        {
            get { return base.ShowAlways;  }
            set { base.ShowAlways = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new bool StripAmpersands
        {
            get { return base.StripAmpersands;  }
            set { base.StripAmpersands = value; }
        }
        #endregion
    }
}
