﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

namespace App.Controls
{
    /// <summary>
    /// ＵＩラベルクラス。
    /// </summary>
    public class UILabel : Label
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UILabel()
        {
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                if (UIControlEventSuppressBlock.Enabled)
                {
                    return false;
                }
                return base.CanRaiseEvents;
            }
        }

        #region デザイナ制御
        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new FlatStyle FlatStyle
        {
            get { return base.FlatStyle;  }
            set { base.FlatStyle = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new bool UseCompatibleTextRendering
        {
            get { return base.UseCompatibleTextRendering; }
            set { base.UseCompatibleTextRendering = value; }
        }
        #endregion
    }


    /// <summary>
    /// ＵＩリンクラベルクラス。
    /// </summary>
    public class UILinkLabel : LinkLabel
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UILinkLabel()
        {
        }

        /// <summary>
        /// リンク範囲を文字列で指定します。
        /// LinkArea プロパティよりは柔軟に設定可能です。
        /// </summary>
        public void SetLinkArea(string linkString)
        {
            // 大文字小文字の違いは無視して検索する
            int startIndex = this.Text.IndexOf(linkString, StringComparison.CurrentCultureIgnoreCase);
            if (startIndex != -1)
            {
                this.LinkArea = new LinkArea(startIndex, linkString.Length);
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                if (UIControlEventSuppressBlock.Enabled)
                {
                    return false;
                }
                return base.CanRaiseEvents;
            }
        }

        #region デザイナ制御
        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new bool UseCompatibleTextRendering
        {
            get { return base.UseCompatibleTextRendering;  }
            set { base.UseCompatibleTextRendering = value; }
        }
        #endregion
    }
}
