﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShellExtension_SyncObject_H__
#define __ShellExtension_SyncObject_H__

//==============================================================================
//
// Base SyncObject
//
//==============================================================================
class CNWSyncObject
{
public :
    CNWSyncObject();
    virtual ~CNWSyncObject();

    //--------------------------------------------------------------------------
    // Lock
    //--------------------------------------------------------------------------
    virtual bool Lock() = 0;

    //--------------------------------------------------------------------------
    // Unlock
    //--------------------------------------------------------------------------
    virtual bool Unlock() = 0;

    //--------------------------------------------------------------------------
    // Try to acquire lock without waiting
    //--------------------------------------------------------------------------
    virtual bool TryLock() = 0;

private :
}; // End of CNWSyncObject


//==============================================================================
//
// Critical Section Class
//
//==============================================================================
class CNWCriticalSection : public CNWSyncObject
{
public :
    CNWCriticalSection();
    virtual ~CNWCriticalSection();

    //--------------------------------------------------------------------------
    // Lock
    //--------------------------------------------------------------------------
    virtual bool Lock();

    //--------------------------------------------------------------------------
    // Unlock
    //--------------------------------------------------------------------------
    virtual bool Unlock();

    //--------------------------------------------------------------------------
    // Try to acquire lock without waiting
    //--------------------------------------------------------------------------
    virtual bool TryLock();

private :
    CRITICAL_SECTION m_CS; ///< Critical section data
}; // End of CNWCriticalSection


//==============================================================================
//
// Helper lock code. On constructor, locks the sync object ( critical section )
// then on destructor, release the lock
//
//==============================================================================
class CNWSingleLock
{
public :
    //--------------------------------------------------------------------------
    // Constructor
    //--------------------------------------------------------------------------
    CNWSingleLock( CNWSyncObject *pSyncObject,
                     bool bInitiallock = true );

    //--------------------------------------------------------------------------
    // Destructor
    //--------------------------------------------------------------------------
    ~CNWSingleLock();

    //--------------------------------------------------------------------------
    // Flag if currently locked
    //--------------------------------------------------------------------------
    bool IsLocked() { return m_bLocked; };

    //--------------------------------------------------------------------------
    // Try lock
    //--------------------------------------------------------------------------
    bool Lock();

    //--------------------------------------------------------------------------
    // Unlock
    //--------------------------------------------------------------------------
    bool Unlock();

private :
    CNWSyncObject   *m_pSyncObject;    ///< SyncObject
    volatile bool      m_bLocked;        ///< Locked flag
}; // End of CNWSingleLock

#endif // End of __ShellExtension_SyncObject_H__

