﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShellExtension_Preview_H__
#define __ShellExtension_Preview_H__

//==============================================================================
//
// Forward declaration
//
//==============================================================================
class CShellExtensionFileData;

//==============================================================================
//
// CShellExtensionPreview
//
//==============================================================================
class ATL_NO_VTABLE CShellExtensionPreview : public CComObjectRootEx<CComSingleThreadModel>,
                                         public CComCoClass<CShellExtensionPreview, &CLSID_ShellExtensionPreview>,
                                         public IPreviewHandler,
                                         public IObjectWithSite,
                                         public IOleWindow,
                                         public IInitializeWithFile,
                                         public IInitializeWithStream
{
public:
    CShellExtensionPreview();
    virtual ~CShellExtensionPreview();

    BEGIN_COM_MAP(CShellExtensionPreview)
        COM_INTERFACE_ENTRY(IPreviewHandler)
        COM_INTERFACE_ENTRY(IObjectWithSite)
        COM_INTERFACE_ENTRY(IOleWindow)
        COM_INTERFACE_ENTRY(IInitializeWithFile)
        COM_INTERFACE_ENTRY(IInitializeWithStream)
    END_COM_MAP()

    // We do not implement here
    static HRESULT WINAPI UpdateRegistry(BOOL bRegister){ NW_USE_VAR(bRegister); return S_OK; }

public:
    // IPreviewHandler
    STDMETHODIMP SetWindow(HWND hwnd, const RECT *prc);
    STDMETHODIMP SetRect(const RECT *prc);
    STDMETHODIMP DoPreview(VOID);
    STDMETHODIMP Unload(VOID);
    STDMETHODIMP SetFocus(VOID);
    STDMETHODIMP QueryFocus(HWND *phwnd);
    STDMETHODIMP TranslateAccelerator(MSG *pmsg);

    // IObjectWithSite
    STDMETHODIMP SetSite(IUnknown *pUnkSite);
    STDMETHODIMP GetSite(REFIID riid, void **ppvSite);

    // IOleWindow
    STDMETHODIMP GetWindow(HWND *phwnd);
    STDMETHODIMP ContextSensitiveHelp(BOOL fEnterMode);

    // IInitializeWithFile
    STDMETHODIMP Initialize( LPCWSTR pszFilePath,
                             DWORD grfMode );

    // IInitializeWithStream
    STDMETHODIMP Initialize(IStream *pstream, DWORD grfMode);

public :
    // Process Message from Preview Window
    LRESULT CALLBACK ProcessMessage( HWND hWnd,
                                     UINT uMsg,
                                     WPARAM wParam,
                                     LPARAM lParam );

private :
    CShellExtensionFileData *m_pFileData;

    HWND m_hParentWindow;
    HWND m_hPreviewWindow;
    RECT m_rect;
    SCROLLINFO m_scrollV;
    SCROLLINFO m_scrollH;

    IUnknown             *m_pSite;
    IPreviewHandlerFrame *m_pFrame;

    Gdiplus::Font        *m_pFont;

    float m_drawingStringMaxSize;

    void OnPaint( PAINTSTRUCT &ps );

    void PaintOnlyImage(PAINTSTRUCT &ps);

public : // Static Data and Interfaces
    static bool InitPreview();

    // Find corresponding preview interface from hWnd and let that interface handle
    // the messages
    static LRESULT CALLBACK HandleWindowProc( HWND hWnd,
                                              UINT uMsg,
                                              WPARAM wParam,
                                              LPARAM lParam );

private :
    static CNWCriticalSection               s_previewCS;
    static std::vector<CShellExtensionPreview*> s_previewInterfaces;

public :
    static bool RegisterService( REGISTRATION_PARAM &param );
    static bool UnregisterService( REGISTRATION_PARAM &param );
}; // End of CShellExtensionPreview

#endif // End of __ShellExtension_Preview_H__

