﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShellExtension_InfoTip_H__
#define __ShellExtension_InfoTip_H__

//==============================================================================
//
// Forward declaration
//
//==============================================================================
class CShellExtensionFileData;

//==============================================================================
//
// CShellExtensionInfoTip
//
//==============================================================================
class ATL_NO_VTABLE CShellExtensionInfoTip : public CComObjectRootEx<CComSingleThreadModel>,
                                         public CComCoClass<CShellExtensionInfoTip, &CLSID_ShellExtensionInfoTip>,
                                         public IPersistFile,
                                         public IQueryInfo
{
public:
    CShellExtensionInfoTip();
    virtual ~CShellExtensionInfoTip();

    BEGIN_COM_MAP(CShellExtensionInfoTip)
        COM_INTERFACE_ENTRY(IPersistFile)
        COM_INTERFACE_ENTRY(IQueryInfo)
    END_COM_MAP()

    // We do not implement here
    static HRESULT WINAPI UpdateRegistry(BOOL bRegister){ NW_USE_VAR(bRegister); return S_OK; }

public:
    // IPersistFile
    STDMETHODIMP GetClassID( CLSID* ) { return E_NOTIMPL; }
    STDMETHODIMP IsDirty() { return E_NOTIMPL; }
    STDMETHODIMP Save( LPCOLESTR, BOOL ) { return E_NOTIMPL; }
    STDMETHODIMP SaveCompleted( LPCOLESTR ) { return E_NOTIMPL; }
    STDMETHODIMP GetCurFile( LPOLESTR* ) { return E_NOTIMPL; }

    STDMETHODIMP Load( LPCOLESTR wszFile, DWORD dwMode );

    // IQueryInfo
    STDMETHODIMP GetInfoFlags(DWORD *pdwFlags);
    STDMETHODIMP GetInfoTip(DWORD dwFlags, LPWSTR *ppwszTip);

private :
    CShellExtensionFileData *m_pFileData;

public :
    static bool RegisterService( REGISTRATION_PARAM &param );
    static bool UnregisterService( REGISTRATION_PARAM &param );
}; // End of CShellExtensionInfoTip

#endif // End of __ShellExtension_InfoTip_H__

