﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShellExtension_ExtractImage_H__
#define __ShellExtension_ExtractImage_H__

//==============================================================================
//
// Forward declaration
//
//==============================================================================
class CShellExtensionFileData;

//==============================================================================
//
// CShellExtensionExtractImage
//
// - Note : This interface is currently not used. ( Needs more time to debug )
//==============================================================================
class ATL_NO_VTABLE CShellExtensionExtractImage : public CComObjectRootEx<CComSingleThreadModel>,
                                              public CComCoClass<CShellExtensionExtractImage, &CLSID_ShellExtensionExtractImage>,
                                              public IPersistFile,
                                              public IExtractImage2
{
public:
    CShellExtensionExtractImage();
    virtual ~CShellExtensionExtractImage();

    BEGIN_COM_MAP(CShellExtensionExtractImage)
        COM_INTERFACE_ENTRY(IPersistFile)
        COM_INTERFACE_ENTRY(IExtractImage)
        COM_INTERFACE_ENTRY(IExtractImage2)
    END_COM_MAP()

    // We do not implement here
    static HRESULT WINAPI UpdateRegistry(BOOL bRegister){ NW_USE_VAR(bRegister); return S_OK; }

public:
    // IPersistFile
    STDMETHODIMP GetClassID( CLSID* ) { return E_NOTIMPL; }
    STDMETHODIMP IsDirty() { return E_NOTIMPL; }
    STDMETHODIMP Save( LPCOLESTR, BOOL ) { return E_NOTIMPL; }
    STDMETHODIMP SaveCompleted( LPCOLESTR ) { return E_NOTIMPL; }
    STDMETHODIMP GetCurFile( LPOLESTR* ) { return E_NOTIMPL; }

    STDMETHODIMP Load( LPCOLESTR wszFile, DWORD dwMode );

    // IExtractImage
    STDMETHODIMP GetLocation( LPWSTR pszPathBuffer,
                              DWORD cchMax,
                              DWORD *pdwPriority,
                              const SIZE *prgSize,
                              DWORD dwRecClrDepth,
                              DWORD *pdwFlags );
    STDMETHODIMP Extract( HBITMAP *phBmpImage );

    // IExtractImage2
    STDMETHODIMP GetDateStamp( FILETIME *pDateStamp );

private :
    CShellExtensionFileData *m_pFileData;
    SIZE                   m_desiredSize;
    FILETIME               m_fileTime;
    std::wstring           m_fileName;

public :
    static bool RegisterService( REGISTRATION_PARAM &param );
    static bool UnregisterService( REGISTRATION_PARAM &param );
}; // End of CShellExtensionExtractImage

#endif // End of __ShellExtension_ExtractImage_H__

