﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShellExtension_PSDLoader_H__
#define __ShellExtension_PSDLoader_H__

//==============================================================================
//
// NW PSDLoader
//
// - Derived from ImageLoader to load .tga files
//
//==============================================================================
class CNWPSDLoader : public CNWImageLoader
{
public :
    CNWPSDLoader();
    virtual ~CNWPSDLoader();

    //--------------------------------------------------------------------------
    // Load from image file onto pTexture
    //
    // - If bLoadPreview is true, create preview image for icon
    //   If bLoadPreview is false, just load information ( format, size etc )
    //--------------------------------------------------------------------------
    _Check_return_
    virtual bool Load( CNWTexture *pTexture,
                       const WCHAR *szFilePath,
                       bool bLoadPreview );

private : // PSD file related types
    struct PSDHeader
    {
        int          signature;
        short        version;
        short        numChannels;
        int          height;
        int          width;
        short        depth;
        short        colorMode;
    };

    struct ImageResourceBlocks
    {
        int            signature;
        short          resourceID;
        unsigned char  nameLen;
        char           name[256];
        int            resourceSize;
    };

    struct ThumbnailResourceHeader
    {
        int            format;
        int            width;
        int            height;
        int            widthBytes;
        int            totalSize;
        int            compressedSize;
        short          pixelBits;
        short          numPlanes;

        ThumbnailResourceHeader()
        {
            memset(this, 0, sizeof(ThumbnailResourceHeader));
        }
    };

    struct LayerCompsInfo
    {
        std::wstring    name;
        NW_EXPORT_SETTING    setting;
    };

    typedef std::map<std::wstring, LayerCompsInfo>    LayerCompsInfoMap;

    struct FileExportSetting
    {
        bool            exportLayerComp;
        bool            outputsTga;
        bool            outputsCtex;
        std::wstring    outputFolder;
        std::wstring    tgaFolder;
        std::wstring    ctexFolder;

        FileExportSetting() :
            exportLayerComp( false ),
            outputsTga( false ),
            outputsCtex( false )
        {
        }
    };


private : // Loading Code
    _Check_return_
    bool ReadPSDHeader(PSDHeader& header, FILE* file);

    _Check_return_
    bool ReadResourceBlock(ImageResourceBlocks& block,
                           FILE* file, int* s);

    _Check_return_
    bool ReadThumbnailHeader(ThumbnailResourceHeader& header,
                             FILE* file, int* s);

    _Check_return_
    bool ReadThumbnailImage(CNWTexture *pTexture,
                            const ThumbnailResourceHeader& header,
                            const void* thumbnailData);

    _Check_return_
    bool ReadLayerComps(std::list<std::wstring>& layerComps,
                        int& lastApplied, FILE* file, int* s);

    _Check_return_
    bool ReadXMLSectionToBuffer( const char *pRawBuffer,
                                           int iBufferSize,
                                           VARIANT *pXMLBuffer );

    //--------------------------------------------------------------------------
    // xmp のメタデータから出力設定を読み込みます
    //
    // 出力設定が読み込めれば true を、読み込めなければ false を返します。
    //--------------------------------------------------------------------------
    _Check_return_
    bool ReadXmpMetadata(NW_EXPORT_SETTING& setting,
                         FileExportSetting& fileExportSetting,
                         std::vector<PSD_LAYER_COMPS>& layerCompsData,
                         const std::list<std::wstring>& layerComps,
                         const PSDHeader& psdHeader,
                         const char* xmpData,
                         int xmpDataSize);
}; // End of CNWPSDLoader

#endif // End of __ShellExtension_PSDLoader_H__

