﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShellExtension_AILoader_H__
#define __ShellExtension_AILoader_H__

//==============================================================================
//
// NW AILoader
//
// - Derived from ImageLoader to load .ai files
//
//==============================================================================
class CNWAILoader : public CNWImageLoader
{
public :
    CNWAILoader();
    virtual ~CNWAILoader();

    //--------------------------------------------------------------------------
    // Load from image file onto pTexture
    //
    // - If bLoadPreview is true, create preview image for icon
    //   If bLoadPreview is false, just load information ( format, size etc )
    //--------------------------------------------------------------------------
    virtual bool Load( CNWTexture *pTexture,
                       const WCHAR *szFilePath,
                       bool bLoadPreview );

}; // End of CNWPSDLoader

#endif // End of __ShellExtension_PSDLoader_H__

