﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Microsoft.VisualBasic.ApplicationServices;

namespace NintendoWare.ExtensionManager
{
    //==========================================================================
    /// <summary>
    /// AboutBox class
    /// </summary>
    //==========================================================================
    public partial class AboutBox : Form
    {
        //----------------------------------------------------------------------
        /// <summary>
        /// Constructor
        /// </summary>
        //----------------------------------------------------------------------
        public AboutBox()
        {
            InitializeComponent();

            // アイコンの表示
            m_pictureBox.Image = MainApp.Instance.UIManager.MainForm.Icon.ToBitmap();

            ApplicationBase application = new ApplicationBase();

            m_productLabel.Text = string.Format("{0} {1} ({2})",
                                                VersionInformation.Name,
                                                VersionInformation.Version,
                                                VersionInformation.BuildDate);

            m_copyRightLabel.Text = application.Info.Copyright;
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Handle Ok Button
        /// </summary>
        //----------------------------------------------------------------------
        private void OnOk(object sender, EventArgs e)
        {
            Close();
        }
    }
}
