﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

namespace NintendoWare.ExtensionManager
{
    //==========================================================================
    /// <summary>
    /// ShellPluginManager
    /// </summary>
    //==========================================================================
    public class ShellPluginManager : SubManager
    {
        private string RootDirectory { get; set; }

        //----------------------------------------------------------------------
        /// <summary>
        /// Constructor
        /// </summary>
        //----------------------------------------------------------------------
        public ShellPluginManager(string rootDir)
        {
            RootDirectory = rootDir;
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Dispose
        /// </summary>
        //----------------------------------------------------------------------
        public override void Dispose()
        {
            base.Dispose();
        }

        #region Init / Deinit
        //----------------------------------------------------------------------
        /// <summary>
        /// Initialization. Override this to customize initialization.
        /// </summary>
        ///
        /// <returns>True if success</returns>
        //----------------------------------------------------------------------
        public override bool Init()
        {
            if (base.Init() == false)
                return false;

            MainApp app = MainApp.Instance;
            Debug.Assert(app!=null);

            String executableDir        = System.IO.Path.GetFullPath(app.ExecutableDirectory + "\\..");

#if DEBUG
            executableDir = System.IO.Path.GetFullPath(
                Environment.ExpandEnvironmentVariables(@"%PROGRAMFILES%\Nintendo\ThumbnailExplorerExtensions"));
#endif

            // FTX
            String ftxModuleWin32Dir = executableDir + "\\Tools\\ftx\\x86\\ShellExtensionFtx.dll";
            String ftxModuleWin64Dir = executableDir + "\\Tools\\ftx\\x64\\ShellExtensionFtx.dll";

            ShellPlugin ftxPlugin = new ShellPlugin();
            ftxPlugin.PluginName = "FTX";
            ftxPlugin.ModulePath32Bit = ftxModuleWin32Dir;
            ftxPlugin.ModulePath64Bit = ftxModuleWin64Dir;

            m_pluginList.Add( ftxPlugin );

            // TGA
            String tgaModuleWin32Dir = executableDir + "\\Tools\\tga\\x86\\ShellExtensionTga.dll";
            String tgaModuleWin64Dir = executableDir + "\\Tools\\tga\\x64\\ShellExtensionTga.dll";

            ShellPlugin tgaPlugin = new ShellPlugin();
            tgaPlugin.PluginName = "TGA";
            tgaPlugin.ModulePath32Bit = tgaModuleWin32Dir;
            tgaPlugin.ModulePath64Bit = tgaModuleWin64Dir;

            m_pluginList.Add(tgaPlugin);

            // PSD
            String PSDModuleWin32Dir = executableDir + "\\Tools\\psd\\x86\\ShellExtensionPsd.dll";
            String PSDModuleWin64Dir = executableDir + "\\Tools\\psd\\x64\\ShellExtensionPsd.dll";

            ShellPlugin PSDPlugin = new ShellPlugin();
            PSDPlugin.PluginName = "PSD";
            PSDPlugin.ModulePath32Bit = PSDModuleWin32Dir;
            PSDPlugin.ModulePath64Bit = PSDModuleWin64Dir;

            m_pluginList.Add(PSDPlugin);

            // AI
            String aiModuleWin32Dir = executableDir + "\\Tools\\Ai\\x86\\ShellExtensionAi.dll";
            String aiModuleWin64Dir = executableDir + "\\Tools\\Ai\\x64\\ShellExtensionAi.dll";

            ShellPlugin aiPlugin = new ShellPlugin();
            aiPlugin.PluginName = "AI";
            aiPlugin.ModulePath32Bit = aiModuleWin32Dir;
            aiPlugin.ModulePath64Bit = aiModuleWin64Dir;

            m_pluginList.Add(aiPlugin);

            // EPS
            String epsModuleWin32Dir = executableDir + "\\Tools\\Eps\\x86\\ShellExtensionEps.dll";
            String epsModuleWin64Dir = executableDir + "\\Tools\\Eps\\x64\\ShellExtensionEps.dll";

            ShellPlugin epsPlugin = new ShellPlugin();
            epsPlugin.PluginName = "EPS";
            epsPlugin.ModulePath32Bit = epsModuleWin32Dir;
            epsPlugin.ModulePath64Bit = epsModuleWin64Dir;

            m_pluginList.Add(epsPlugin);

            // THUMBS
            String thumbsModuleWin32Dir = executableDir + "\\Tools\\Thumbs\\x86\\ShellExtensionThumbs.dll";
            String thumbsModuleWin64Dir = executableDir + "\\Tools\\Thumbs\\x64\\ShellExtensionThumbs.dll";

            ShellPlugin thumbsPlugin = new ShellPlugin();
            thumbsPlugin.PluginName = "THUMBS";
            thumbsPlugin.ModulePath32Bit = thumbsModuleWin32Dir;
            thumbsPlugin.ModulePath64Bit = thumbsModuleWin64Dir;

            m_pluginList.Add(thumbsPlugin);

            return true;
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Cleanup code. Overridable
        /// </summary>
        //----------------------------------------------------------------------
        public override void Deinit()
        {
            base.Deinit();
        }
        #endregion

        #region Plugin
        //----------------------------------------------------------------------
        /// <summary>
        /// Plugin List
        /// </summary>
        //----------------------------------------------------------------------
        public ShellPlugin FindPlugin( String name )
        {
            foreach (ShellPlugin plugin in m_pluginList)
            {
                if (String.Equals( plugin.PluginName, name, StringComparison.CurrentCultureIgnoreCase ))
                    return plugin;
            }

            return null;
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Plugins
        /// </summary>
        //----------------------------------------------------------------------
        public IEnumerable<ShellPlugin> Plugins
        {
            get
            {
                return m_pluginList;
            }
        }

        private List<ShellPlugin> m_pluginList = new List<ShellPlugin>();
        #endregion

    }
}
