; ThumbnailExplorerExtention ̃CXg[

[Setup]
AppName=NintendoSDK-ThumbnailExplorerExtensions
AppVersion=2.2.0.0
; I[͊1OK
AppId={{8BF8D3FF-8B61-480A-ACB8-9225E4DFFCD1}
SetupMutex=8F2B7955-269A-472E-9D9A-7320D41CEEC0,Global\8F2B7955-269A-472E-9D9A-7320D41CEEC0
AppPublisher=Nintendo
UninstallDisplayIcon={app}\ExtensionInstaller.exe
DefaultDirName={pf}\Nintendo\ThumbnailExplorerExtensions
UsePreviousAppDir=no
DisableDirPage=yes
DisableProgramGroupPage=yes
DisableReadyMemo=yes
CloseApplications=no
Compression=lzma2
SolidCompression=yes
ArchitecturesAllowed=x64
ArchitecturesInstallIn64BitMode=x64


#include "ExtensionInstaller_Lang.iss"


[Files]
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\IronPython.dll";                   DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\IronPython.Modules.dll";           DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\Microsoft.Dynamic.dll";            DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\Microsoft.Scripting.dll";          DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\Microsoft.Scripting.Metadata.dll"; DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\TextureViewer.exe";                DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\Nintendo.G3dTool.dll";                            DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\Opal.dll";                                        DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\3dIntermediateFileLibrary.dll";                   DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\3dIntermediateFileSerializer.dll";                DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\3dIntermediateFileSerializer.XmlSerializers.dll"; DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\3dIntermediateFileTextureUtility.dll";            DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\ToolFoundation.dll";            DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\System.Interactive.dll";            DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion

Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\TextureViewer\3dTools\3dIntermediateFileXsd\*";          DestDir: "{app}\Tools\TextureViewer\3dTools\3dIntermediateFileXsd"; Flags: recursesubdirs ignoreversion

Source: "..\..\..\..\..\..\..\Tools\Graphics\GraphicsTools\TextureConverterEncoder.dll";            DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\GraphicsTools\PVRTexLib.dll";                          DestDir: "{app}\Tools\TextureViewer"; Flags: ignoreversion

                 
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\Ftx\x86\ShellExtensionFtx.dll";     DestDir: "{app}\Tools\Ftx\x86"; Flags: ignoreversion                 
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\Ftx\x64\ShellExtensionFtx.dll";     DestDir: "{app}\Tools\Ftx\x64"; Flags: ignoreversion                
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\Psd\x86\ShellExtensionPsd.dll";     DestDir: "{app}\Tools\Psd\x86"; Flags: ignoreversion                
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\Psd\x64\ShellExtensionPsd.dll";     DestDir: "{app}\Tools\Psd\x64"; Flags: ignoreversion                
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\Tga\x86\ShellExtensionTga.dll";     DestDir: "{app}\Tools\Tga\x86"; Flags: ignoreversion                
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\Tga\x64\ShellExtensionTga.dll";     DestDir: "{app}\Tools\Tga\x64"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\Ai\x86\ShellExtensionAi.dll";       DestDir: "{app}\Tools\Ai\x86";  Flags: ignoreversion                
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\Ai\x64\ShellExtensionAi.dll";       DestDir: "{app}\Tools\Ai\x64";  Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\Eps\x86\ShellExtensionEps.dll";     DestDir: "{app}\Tools\Eps\x86"; Flags: ignoreversion                
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\Eps\x64\ShellExtensionEps.dll";     DestDir: "{app}\Tools\Eps\x64"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\Thumbs\x86\ShellExtensionThumbs.dll";     DestDir: "{app}\Tools\Thumbs\x86"; Flags: ignoreversion                
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Tools\Thumbs\x64\ShellExtensionThumbs.dll";     DestDir: "{app}\Tools\Thumbs\x64"; Flags: ignoreversion

Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Setup\ExtensionManager.exe";            DestDir: "{app}\Setup"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Setup\session_config.xml";              DestDir: "{app}\Setup"; Flags: ignoreversion
Source: "..\..\..\..\..\..\..\Tools\Graphics\ThumbnailExplorerExtensions\Setup\session-application-list.xml";    DestDir: "{app}\Setup"; Flags: ignoreversion

[Code]
var
  RestartExplorer: Boolean;

[Code]

var
UninstallString: String;
IsSameVersion: Boolean;

LabelMessage: TLabel;                            
RbtnReinstall: TRadioButton;
LabelReinstall: TLabel;
RbtnUninstall: TRadioButton;
LabelUninstall: TLabel;

ForceClose: Boolean;


//
// [hIʂɊւf[^܂B
//
procedure InitializeSelectionModePage();
var
  UninstallPath: String;
  DisplayVersion: String;
begin
  UninstallPath := ExpandConstant('Software\Microsoft\Windows\CurrentVersion\Uninstall\{#emit SetupSetting("AppId")}_is1');
  UninstallString := '';
  DisplayVersion := '';

  // WXg擾
  if not RegQueryStringValue(HKEY_LOCAL_MACHINE, UninstallPath, 'UninstallString', UninstallString) then
    RegQueryStringValue(HKEY_CURRENT_USER, UninstallPath, 'UninstallString', UninstallString);

  if not RegQueryStringValue(HKEY_LOCAL_MACHINE, UninstallPath, 'DisplayVersion', DisplayVersion) then
    RegQueryStringValue(HKEY_CURRENT_USER, UninstallPath, 'DisplayVersion', DisplayVersion);

  UninstallString := RemoveQuotes(UninstallString);
  IsSameVersion := DisplayVersion = '{#SetupSetting("AppVersion")}';
end;


//
// [hIʂ\邩B
//
function IsSelectionModePageVisible(): Boolean;
begin
  if UninstallString <> '' then
    Result := True
  else
    Result := False;
end;


//
// [hIʂŎւ̃{^Ƃ̏s܂B
//
function SelectionModePage_NextButtonClick(Page: TWizardPage): Boolean;
var
  ResultCode: Integer;
  Options: String;
begin
  Result := True;

  Options := '/VERYSILENT /NORESTART /SUPRESSMSGBOXES ';
  if not RestartExplorer then
    Options := Options + '/no-restart-explorer ';

  if RbtnReinstall.Checked = True then
  begin
    Exec(UninstallString, Options, '', SW_HIDE, ewWaitUntilTerminated, ResultCode);
    if ResultCode <> 0 then
    begin
      Result := False;
      WizardForm.Close;
    end;
  end
  else
  begin
    Exec(UninstallString, Options, '', SW_HIDE, ewWaitUntilTerminated, ResultCode);
    if ResultCode <> 0 then
      Result := False
    else
      ForceClose := True;
    WizardForm.Close;
  end;
end;


//
// [hIʂŃLZ{^Ƃ܂
// ACXg[ătH[Ƃ̏s܂B
//
procedure SelectionNodePage_CancelButtonClick(Page: TWizardPage; var ACancel, AConfirm: Boolean);
begin
  AConfirm := not ForceClose;
end;


//
// [hIʂ쐬܂B
//
function SelectionModePage_CreatePage(PreviousPageId: Integer): Integer;
var
  Page: TWizardPage;
  PageTitle: String;
  PageMessage: String;
  ReinstallCaption: String;
  ReinstallLabel: String;
begin

  if IsSameVersion = True then
  begin
    PageTitle := CustomMessage('RepairOrUninstall');
    PageMessage := CustomMessage('SameVersionIsAlreadyInstalled');
    ReinstallCaption := CustomMessage('Repair');
    ReinstallLabel := CustomMessage('RepairDescription');
  end
  else
  begin
    PageTitle := CustomMessage('UpdateOrUninstall');
    PageMessage := CustomMessage('DiffVersionIsAlreadyInstalled');
    ReinstallCaption := CustomMessage('Update');
    ReinstallLabel := CustomMessage('UpdateDescription');
  end;

  Page:= CreateCustomPage(PreviousPageId, PageTitle, '');

  LabelMessage := TLabel.Create(Page);
  with LabelMessage do
  begin
    Parent  := Page.Surface;
    Caption := PageMessage;
    Left    := ScaleX(0);
    Top     := ScaleY(0);
    Width   := ScaleX(400);
    Height  := ScaleY(34);
  end;

  RbtnReinstall := TRadioButton.Create(Page);
  with RbtnReinstall do
  begin
    Parent   := Page.Surface;
    Caption  := ReinstallCaption;
    Left     := ScaleX(16);
    Top      := ScaleY(58);
    Width    := ScaleX(150);
    Height   := ScaleY(17);
    Checked  := False;
    TabOrder := 1;
    TabStop  := True;
  end;

  LabelReinstall := TLabel.Create(Page);
  with LabelReinstall do
  begin
    Parent  := Page.Surface;
    Caption := ReinstallLabel;
    Left    := ScaleX(33);
    Top     := ScaleY(81);
    Width   := ScaleX(400);
    Height  := ScaleY(17);
  end;

  RbtnUninstall := TRadioButton.Create(Page);
  with RbtnUninstall do
  begin
    Parent   := Page.Surface;
    Caption  := CustomMessage('Uninstall');
    Left     := ScaleX(16);
    Top      := ScaleY(117);
    Width    := ScaleX(150);
    Height   := ScaleY(17);
    Checked  := False;
    TabOrder := 1;
    TabStop  := True;
  end;

  LabelUninstall := TLabel.Create(Page);
  with LabelUninstall do
  begin
    Parent  := Page.Surface;
    Caption := CustomMessage('UninstallDescription');
    Left    := ScaleX(33);
    Top     := ScaleY(140);
    Width   := ScaleX(400);
    Height  := ScaleY(17);
  end;

  with Page do
  begin
    OnNextButtonClick := @SelectionModePage_NextButtonClick;
    OnCancelButtonClick := @SelectionNodePage_CancelButtonClick;
  end;

  ForceClose := False;
  
  Result := Page.ID;
end;

#ifdef UNICODE
  #define AW "W"
#else
  #define AW "A"
#endif

#define HWND 'NW_EM_SETUP_HWND'

var
  ShowSetupManagerCheckBox: TNewCheckBox;
  CustomExitCode: Integer;
  IsVerySilent: Boolean;
  RemoveCustom: Boolean;

//
// vZXϐݒ肵܂B
//
function SetEnvironmentVariable(lpName: string; lpValue: string): BOOL;
  external 'SetEnvironmentVariable{#AW}@kernel32.dll stdcall';



function Initialize(): Boolean;
var
  i: Integer;
begin
  Result := True;

  // O[oϐ̏
  CustomExitCode := 0;
  IsVerySilent := False;
  RemoveCustom := False;
  RestartExplorer := True;

  for i := 1 to ParamCount do
    if CompareText(ParamStr(i), '/verysilent') = 0 then
    begin
      IsVerySilent := True
    end else if CompareText(ParamStr(i), '/remove-custom') = 0 then
    begin
      RemoveCustom := True
    end else if CompareText(ParamStr(i), '/no-restart-explorer') = 0 then
    begin
      RestartExplorer := False
    end;      
end;

//
// CXg[̏Cxg܂B
//
function InitializeSetup(): Boolean;
begin
  Result := Initialize();
end;

function InitializeUninstall(): Boolean;
begin
  Result := Initialize();
end;



procedure InitializeWizard();
begin
  // EBU[h̃nhvZXϐɐݒ
  if GetEnv('{#HWND}') = '' then
    SetEnvironmentVariable('{#HWND}', ExpandConstant('{wizardhwnd}'));

  // ZbgAbv}l[W[\̃`FbN{bNX̏
  ShowSetupManagerCheckBox := TNewCheckBox.Create(WizardForm);
  with ShowSetupManagerCheckBox do
  begin
    Parent := WizardForm.ReadyPage;
    Top := ScaleY(24);
    Width := WizardForm.ReadyPage.Width;
    Checked := False;
    Caption := CustomMessage('ShowSetupManager');
  end;

  // CXg[ނ̑I
  InitializeSelectionModePage();

  if IsSelectionModePageVisible() = True then
    SelectionModePage_CreatePage(wpLicense);
end;

//
// CXg[̉ʑJڃCxg܂B
//
procedure CurPageChanged(CurPageID: Integer);
begin
//  MsgBox('CurPageChanged()' + IntToStr(CurPageId), mbInformation, MB_OK);
  // CXg[Jny[W̖߂{^\ɂ
  if CurPageID = wpReady then
    WizardForm.BackButton.Visible := False;
end;


//
// CXg[̃XebvCxg܂B
//
procedure CurStepChanged(CurStep: TSetupStep);
var
  ResultCode: Integer;
  Options: String;
  CustomExtensions: String;
begin
  // CXg[O
  if CurStep = ssInstall then
  begin
//    MsgBox('PreInstall()', mbInformation, MB_OK);

    // CXg[g킸ɔzuꂽt@C̓o^
    Options :='-e -u ';
    if not RestartExplorer then
      Options := Options + '-s ';

    if FileExists(ExpandConstant('{app}\Setup\ExtensionManager.exe')) then
      Exec(ExpandConstant('{app}\Setup\ExtensionManager.exe'), Options, '', SW_SHOW, ewWaitUntilTerminated, ResultCode);

    // cpꃊ\[X폜
    if ExpandConstant('{language}') = 'jp' then
    begin
      if FileExists(ExpandConstant('{app}\Setup\en\ExtensionManager.resources.dll')) then
        DeleteFile(ExpandConstant('{app}\Setup\en\ExtensionManager.resources.dll'));

      if FileExists(ExpandConstant('{app}\Tools\TextureViewer\en\TextureViewer.resources.dll')) then
        DeleteFile(ExpandConstant('{app}\Tools\TextureViewer\en\TextureViewer.resources.dll'));
    end;
  end;

  // CXg[㏈
  if CurStep = ssPostInstall then
  begin
    if ShowSetupManagerCheckBox.Checked = True then
      Options := '-c '
    else
      Options := '-e ';

    if not RestartExplorer then
      Options := Options + '-s ';

    if RemoveCustom then
      Options := Options + '--remove-custom ';
    
    CustomExtensions := ExpandConstant('{param:custom}');
    if  Length(CustomExtensions) > 0 then
      Options := Options + '--custom '+CustomExtensions;

    Exec(ExpandConstant('{app}\Setup\ExtensionManager.exe'), Options, '', SW_SHOW, ewWaitUntilTerminated, ResultCode);

    // \񂳂ĂG[R[hƂԂȂ悤 100 𑫂܂B
    if ResultCode <> 0 then
      CustomExitCode:=100+ResultCode;
  end;
end;

//
// AXg[̉ʑJڃCxg܂B
//
procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
var
  ResultCode: Integer;
  Options: String;
begin
  // ACXg[O
  if CurUninstallStep = usUninstall then
  begin
    //MsgBox('CurUninstallStepChanged()' + IntToStr(Integer(IsVerySilent)), mbInformation, MB_OK);

    // ACXg[̃EBhEnhݒ
    if GetEnv('{#HWND}') = '' then
      SetEnvironmentVariable('{#HWND}', IntToStr(UninstallProgressForm.Handle));

    Options := '-e -u ';
    if not RestartExplorer then
      Options := Options + '-s ';
    Exec(ExpandConstant('{app}\Setup\ExtensionManager.exe'), Options, '', SW_SHOW, ewWaitUntilTerminated, ResultCode);

    // \񂳂ĂG[R[hƂԂȂ悤 200 𑫂܂B
    if ResultCode <> 0 then
    begin
      CustomExitCode:=200+ResultCode;
      Abort;
    end;
  end;

  // ACXg[㏈
  if CurUninstallStep = usPostUninstall then
  begin
//    MsgBox('PostUninstall()', mbInformation, MB_OK);
  end;
end;

function GetCustomSetupExitCode: Integer;
begin
  Result := CustomExitCode;
end;
