﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel;
using System.Text;
using System.Threading;

namespace nw.g3d.bifedit.IPC
{
    [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single)]
    public class RemoteControllerService : IRemoteController
    {
        public event Action ShowUserInterfaceRequested;
        public event Action<string> EditorProcessFileRequested;
        public event Action<string[]> CompaleProcessFileRequested;

        public void ShowUserInterface()
        {
            if (ShowUserInterfaceRequested != null)
                ShowUserInterfaceRequested();
        }

        public void EditorProcessFile(string filename)
        {
            if (EditorProcessFileRequested != null)
                EditorProcessFileRequested(filename);
        }

        public void CompaleProcessFile(string[] args)
        {
            if (CompaleProcessFileRequested != null)
                CompaleProcessFileRequested(args);
        }
    }
}
