﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nns/nac/nac_MemoryAllocator.h>

// ----------------------------------------------------------------------------
// アロケータ
// ----------------------------------------------------------------------------
class SimpleAllocator : public nns::nac::MemoryAllocator
{
public:
    SimpleAllocator()
        : m_OccupiedSize(0)
        , m_MaxSize(0)
        , m_pTop(NULL)
        , m_pBottom(NULL)
        , m_IsMemoryLeakCheckingEnabled(false)
    {
    }

    virtual void* Alloc(size_t size)
    {
        return AllocateMemory(static_cast<size_t>(size), 1);
    }

    virtual void* Alloc(size_t size, int alignment)
    {
        return AllocateMemory(static_cast<size_t>(size), static_cast<size_t>(alignment));
    }

    virtual void* Alloc(size_t size, size_t alignment)
    {
        return AllocateMemory(size, static_cast<size_t>(alignment));
    }

    virtual void Free(void* ptr)
    {
        FreeMemory(ptr);
    }

    void* AllocateMemory(size_t size, size_t alignment);

    void FreeMemory(void* pointer);

    // 確保中の総メモリサイズを取得します
    int64_t GetOccupiedSize() const;

    // メモリの最大使用量を取得します
    int64_t GetMaxSize() const;

    // 確保中のメモリを列挙して表示します
    void PrintOccupiedMemory() const;

    void SetMemoryLeakCheckingEnabled(bool enabled)
    {
        m_IsMemoryLeakCheckingEnabled = enabled;
    }

private:
    // メモリのアドレスとサイズをリストで管理
    struct MemoryList
    {
        MemoryList* pNext;
        void* pAddress;
        size_t size;
        bool isMemoryLeakCheckingEnabled;
    };

    int64_t m_OccupiedSize;
    int64_t m_MaxSize;
    MemoryList* m_pTop;
    MemoryList* m_pBottom;
    bool m_IsMemoryLeakCheckingEnabled;
};
